#ifndef LMITECH_KVISION_L3D_SYSTEMALIGNBAR_X_H_INCLUDED
#define LMITECH_KVISION_L3D_SYSTEMALIGNBAR_X_H_INCLUDED

#include <kApi/kApi.h>
#include <kVision/L3d/kL3dUtilities.h>
//#include <kVision/L3d/kL3dChartPlotter.h>
#include <math.h>
#include <kVision/Common/kMatrix.h>
#include <kVision/L3d/kL3dSystemAlignBarUtilities.h>

#define KL3D_SYSTEM_ALIGN_BAR_MIN_FIT_VALID            (10)
#define KL3D_SYSTEM_ALIGN_BAR_START_ROW_CAPACITY        (400)
#define KL3D_SYSTEM_ALIGN_BAR_START_POINT_CAPACITY    (2500)
#define KL3D_SYSTEM_ALIGN_BAR_INLIER_FRACTION            (0.9) 

//Input parameters
typedef struct kL3dSystemAlignBarParams 
{

    k64f barWidth;
    k64f slotSpacing;
    k32u slotSeen;

    k64f depthThreshold;
    k64f slotThreshold;

    kL3dTransform3d sourceTransform;
    kVsSystemCalibrationReferenceType referenceType;

    k32u levelSampleCount;
    k64f edgeThreshold;
    //k32u maxSampleCount;

    k64f encoderResolution;
    k64s encoderY;

    kPoint3d64f resolution;

} kL3dSystemAlignBarParams;

//Output parameters
typedef struct kL3dSystemAlignBarResults 
{
    kL3dTransform3d alignTransform;
    kPoint3d64f translations;//The x,y,z translations.  
    kPoint3d64f rotations;//The rotations about the x, y, and z axis.
    //k64f rotationAroundY;
    //k64f rotationAroundZ;

    k64f encoderSpacing;

    kPoint3d64f slotCentre;

    k64f calculatedBarWidth;
    k64f barAngle;
} kL3dSystemAlignBarResults;

typedef struct kL3dSystemAlignBarRowData 
{
    //k64s position;

    k64f slope;
    k64f intercept;

    k32u validCount;
} kL3dSystemAlignBarRowData;

typedef struct BarCalGroundData 
{
    k64f slope;
    k64f intercept;

    k32u validCount;
    k32u count;

    k64f angle;
    k64f sinAngle;
    k64f cosAngle;

} BarCalGroundData;

typedef struct kL3dSystemAlignBarClass 
{
    kObjectClass base;
    kL3dSystemAlignBarParams params;

    kL3dBarCalState state;
    BarCalGroundData groundData;

    //kArrayList pointBuffer;
    //kArrayList tempBuffer;
    kArrayList rows;

    kArrayList leadingEdge;
    kArrayList trailingEdge;
    kArrayList slotEdgePoints;//The location of the first hole.
    kArrayList runCounter;

    kBool encoderBased;
    k64s yStart;
    k64s yEnd;
    k64s tStart;
    k64s tEnd;

    kArray2 surface;

    kL3dSystemAlignBarResults results;

} kL3dSystemAlignBarClass;

kDeclareClassEx(kVs, kL3dSystemAlignBar, kObject)
kDeclareValueEx(kVs, kL3dSystemAlignBarRowData, kValue)

/**
* Destroys a kP3dSystemAlignBar object.
*
* @public               @memberof kL3dSystemAlignBar
* @param   object       Destination for the constructed object handle.
* @return               Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_VRelease(kL3dSystemAlignBar object);

kStatus kL3dSystemAlignBar_Init(kL3dSystemAlignBar object, kAlloc alloc);
kStatus kL3dSystemAlignBar_RunInit(kL3dSystemAlignBar object);
kStatus kL3dSystemAlignBar_Release(kL3dSystemAlignBar object);

kStatus kL3dSystemAlignBar_ResizeBuffers(kL3dSystemAlignBar object, k32u count);

kStatus kL3dSystemAlignBar_TransformPoints(kL3dSystemAlignBar object, kArray2 points, k32u sampleIndex);
kStatus kL3dSystemAlignBar_FitPoints(kL3dSystemAlignBar object, kPoint64f* points, k32u count, k64f* slope, k64f* intercept);


/**
* Finds the hole in the bar.
*
* @private              @memberof kL3dSystemAlignBar
* @param   minWidth     The minimum distance required to find the bar.  This must be less than the distance between the end of the bar and the hole.
* @param   
* @return               Operation status.
*/
//kStatus kL3dSystemAlignBar_FindGap(kL3dSystemAlignBar object, kArray2 pointsArray, k32u sampleIndex, k64f minWidth, kPoint3d64f* result0, kPoint3d64f* result1);
kStatus kL3dSystemAlignBar_FindGap(kL3dSystemAlignBar object, kArray2 pointsArray, k32u sampleIndex, k64f minEdgeWidth, k64f minSlotWidth, kPoint3d64f* result0, kPoint3d64f* result1);

kStatus kL3dSystemAlignBar_ProcessRow(kL3dSystemAlignBar object, kArray2 surface, k32u sampleIndex, k32u validCount, k32u minFitValid,
    k64f zMin, k64f zMax, kL3dSystemAlignBarRowData* rowData);

//kStatus kL3dSystemAlignBar_GeneratePlot(kL3dSystemAlignBar object, kArrayList leadingPoints, kArrayList trailingPoints, k64f yRes,
//    k64f slope0, k64f int0, k64f slope1, k64f int1, kPoint64f* sectionP0, kPoint64f* sectionP1,
//    kArrayList referencePoints, kPoint3d64f* reference, kPlot* plot);
kStatus kL3dSystemAlignBar_RejectXOutliers(kL3dSystemAlignBar object, kArrayList referencePoints, k64f rangeFactor);

kStatus kL3dSystemAlignBar_ResetRunCounter(kL3dSystemAlignBar object);
kStatus kL3dSystemAlignBar_ResetSearch(kL3dSystemAlignBar object);
k32u kL3dSystemAlignBar_ValidRowsFound(kL3dSystemAlignBar object);






kStatus kL3dSystemAlignBar_FitPointsXZ(kL3dSystemAlignBar object, kArray2 points, k32u sampleIndex, k32u validCount, k64f *slope, k64f *intercept);
kStatus kL3dSystemAlignBar_FitPointsRobust(kL3dSystemAlignBar object, kArray2 pointsArray, k32u sampleIndex, k32u validCount, kPoint3d64f* offsetBuffer, k64f fraction,
    k64f* slope, k64f* intercept);
kStatus kL3dSystemAlignBar_FindBackground(kL3dSystemAlignBar object, kArray2 surface, kArray1 validCount);
kStatus kL3dSystemAlignBar_CalculateValidPoints(kL3dSystemAlignBar object, kArray2 source, kArray1 validCount);
//kStatus kL3dSystemAlignBar_CalculatePlotInfo(kL3dSystemAlignBar object);

#endif
