#ifndef kL3D_PROFILE_SAMPLER_BLOCK_INFO_H
#define kL3D_PROFILE_SAMPLER_BLOCK_INFO_H

#include <kVision/L3d/kL3dProfileSampler.h>

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#define kL3D_PROFILE_SAMPLER_BLOCK_NAME              "G2_ProfileSampler"

#define kL3D_PROFILE_SAMPLER_BLOCK_INPUT_NAME        "Input"
#define kL3D_PROFILE_SAMPLER_BLOCK_OUTDATA_NAME      "OutData"
#define kL3D_PROFILE_SAMPLER_BLOCK_OUTPLOT_XY_NAME   "OutPlotXY"
#define kL3D_PROFILE_SAMPLER_BLOCK_OUTPLOT_XZ_NAME   "OutPlotXZ"
#define kL3D_PROFILE_SAMPLER_BLOCK_OUTINTENSITY_NAME "OutIntensity"

typedef enum
{
    kL3D_PROFILE_SAMPLER_BLOCK_INPUT = 0,
    kL3D_PROFILE_SAMPLER_BLOCK_OUTDATA = 1000,
    kL3D_PROFILE_SAMPLER_BLOCK_OUTINTENSITY = 2000,
    kL3D_PROFILE_SAMPLER_BLOCK_OUTPLOT_XY = 3000,
    kL3D_PROFILE_SAMPLER_BLOCK_OUTPLOT_XZ = 4000
} kL3dProfileSamplerPort;

typedef kObject kL3dProfileSamplerBlockInfo;

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) kL3dProfileSamplerBlockInfo_Construct(kL3dProfileSamplerBlockInfo* info, kAlloc allocator);

kVsFx(kStatus) kL3dProfileSamplerBlockInfo_Load(kL3dProfileSamplerBlockInfo * info, kXml xml, kAlloc allocator);
kVsFx(kStatus) kL3dProfileSamplerBlockInfo_Store(kL3dProfileSamplerBlockInfo info, kXml* xml, kAlloc allocator);

kVsFx(kStatus) kL3dProfileSamplerBlockInfo_Read(kL3dProfileSamplerBlockInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kL3dProfileSamplerBlockInfo_Write(kL3dProfileSamplerBlockInfo info, kXml xml, kXmlItem item);

//////////////////////////////////////////////////////////////////////////
// Set / Get
// See kL3dProfileSampler for details
//////////////////////////////////////////////////////////////////////////

kInlineFx(kStatus)kL3dProfileSamplerBlockInfo_SetFov(kL3dProfileSamplerBlockInfo info, kRect64f val);
kInlineFx(kRect64f)kL3dProfileSamplerBlockInfo_Fov(kL3dProfileSamplerBlockInfo info);

kInlineFx(kStatus) kL3dProfileSamplerBlockInfo_SetDataOrigin(kL3dProfileSamplerBlockInfo info, kPoint64f val);
kInlineFx(kPoint64f) kL3dProfileSamplerBlockInfo_DataOrigin(kL3dProfileSamplerBlockInfo info);

kInlineFx(kStatus) kL3dProfileSamplerBlockInfo_SetXStep(kL3dProfileSamplerBlockInfo info, k64f val);
kInlineFx(k64f) kL3dProfileSamplerBlockInfo_XStep(kL3dProfileSamplerBlockInfo info);

kInlineFx(kStatus) kL3dProfileSamplerBlockInfo_SetXResolution(kL3dProfileSamplerBlockInfo info, k64f val);
kInlineFx(k64f) kL3dProfileSamplerBlockInfo_XResolution(kL3dProfileSamplerBlockInfo info);

kInlineFx(kStatus) kL3dProfileSamplerBlockInfo_SetZResolution(kL3dProfileSamplerBlockInfo info, k64f val);
kInlineFx(k64f) kL3dProfileSamplerBlockInfo_ZResolution(kL3dProfileSamplerBlockInfo info);

kInlineFx(kStatus) kL3dProfileSamplerBlockInfo_SetXStepThreshold(kL3dProfileSamplerBlockInfo info, k64f val);
kInlineFx(k64f) kL3dProfileSamplerBlockInfo_XStepThreshold(kL3dProfileSamplerBlockInfo info);

kInlineFx(kStatus) kL3dProfileSamplerBlockInfo_SetZSlopeThreshold(kL3dProfileSamplerBlockInfo info, k64f val);
kInlineFx(k64f) kL3dProfileSamplerBlockInfo_ZSlopeThreshold(kL3dProfileSamplerBlockInfo info);

kInlineFx(kStatus) kL3dProfileSamplerBlockInfo_SetFillAllAdjacent(kL3dProfileSamplerBlockInfo info, kBool val);
kInlineFx(kBool) kL3dProfileSamplerBlockInfo_FillAllAdjacent(kL3dProfileSamplerBlockInfo info);

kInlineFx(kStatus) kL3dProfileSamplerBlockInfo_SetBottomSensor(kL3dProfileSamplerBlockInfo info, kBool val);
kInlineFx(kBool) kL3dProfileSamplerBlockInfo_BottomSensor(kL3dProfileSamplerBlockInfo info);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#include <kVision/L3d/kL3dProfileSamplerBlockInfo.z.h>

#endif /* #ifndef kL3D_PROFILE_SAMPLER_BLOCK_INFO_H */
