#ifndef LMITECH_KVISION_L3D_POLYNOMIALCALDATA_H_INCLUDED
#define LMITECH_KVISION_L3D_POLYNOMIALCALDATA_H_INCLUDED

#include <kVision/L3d/kL3dCalData.h>
#include <kVision/L3d/kL3dPolynomial.h>
#include <kVision/L3d/kL3dPolynomialArray.h>
#include <kFireSync/Data/kDataTree.h>

/**
* @class   kL3dPolynomialCalData
* @extends kL3dCalData
* @ingroup kVision-kL3d
* @brief   
*/

typedef kL3dCalData kL3dPolynomialCalData;

/**
* Constructs a kL3dPolynomialCalData object.
*
* @public              @memberof kL3dPolynomialCalData
* @param   data        Receives the constructed object.
* @param   count       Number of entries.
* @param   maxXOrder   The maximum order of the X polynomial.
* @param   maxYOrder   The maximum order of the Y polynomial.
* @param   maxZOrder   The maximum order of the Z polynomial.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kL3dPolynomialCalData_Construct(kL3dPolynomialCalData* data, k32u count, k32u maxXOrder, k32u maxYOrder, k32u maxZOrder, kAlloc allocator);

/**
* Constructs a kL3dPolynomialCalData object from a kDataTree.
*
* @public              @memberof kL3dPolynomialCalData
* @param   calData     A constructed kL3dPolynomialCalData object.
* @param   tree        Tree object.
* @param   item        Tree item.
* @return              Operation status.
*/
kVsFx(kStatus) kL3dPolynomialCalData_Import(kL3dPolynomialCalData* data, kDataTree tree, kDataTreeItem item, kAlloc allocator);

/**
* kArray2<64f> representing polynomial mapping between centroids and X range coordinates
* Dimensions of the array are (slice count) * (maxXOrder + 2)
* 
* Values at a given row specify the polynomial function for a given slice in the following format
* 
* row[0] - order of the polynomial
* row[1..order + 2] - polynomial coefficients
*
* @public              @memberof kL3dPolynomialCalData
* @param   data        A kL3dPolynomialCalData object.
* @return              kArray2<64f>.
*/
kVsFx(kArray2) kL3dPolynomialCalData_CentreToX(kL3dPolynomialCalData data);

/**
* kArray2<64f> representing polynomial mapping between centroids and Y range coordinates
* Dimensions of the array are (slice count) * (maxXOrder + 2)
*
* Values at a given row specify the polynomial function for a given slice in the following format
*
* row[0] - order of the polynomial
* row[1..order + 2] - polynomial coefficients
*
* @public              @memberof kL3dPolynomialCalData
* @param   data        A kL3dPolynomialCalData object.
* @return              kArray2<64f>.
*/
kVsFx(kArray2) kL3dPolynomialCalData_CentreToY(kL3dPolynomialCalData data);

/**
* kArray2<64f> representing polynomial mapping between centroids and Z range coordinates
* Dimensions of the array are (slice count) * (maxXOrder + 2)
*
* Values at a given row specify the polynomial function for a given slice in the following format
*
* row[0] - order of the polynomial
* row[1..order + 2] - polynomial coefficients
*
* @public              @memberof kL3dPolynomialCalData
* @param   data        A kL3dPolynomialCalData object.
* @return              kArray2<64f>.
*/
kVsFx(kArray2) kL3dPolynomialCalData_CentreToZ(kL3dPolynomialCalData data);

#include <kVision/L3d/kL3dPolynomialCalData.x.h>

#endif /* #ifndef LMITECH_KVISION_L3D_POLYNOMIALCALDATA_H_INCLUDED */
