#ifndef LMITECH_KVISION_L3D_POLYNOMIAL2_H_INCLUDED
#define LMITECH_KVISION_L3D_POLYNOMIAL2_H_INCLUDED

#include <kVision/L3d/kL3dCommon.h>

#define kL3D_POLYNOMIAL2_INVALID_ORDER (k32U_NULL)

typedef kPointer kL3dPolynomial2;

kVsFx(k64f)    kL3dPolynomial2_Apply(kL3dPolynomial2 poly, k64f x, k64f y);
kVsFx(kStatus) kL3dPolynomial2_ApplyN(kL3dPolynomial2 poly, k64f* x, k64f* y, k64f* f, k32u count);
kVsFx(kStatus) kL3dPolynomial2_Clear(kL3dPolynomial2 poly);
kVsFx(kBool)   kL3dPolynomial2_IsValid(kL3dPolynomial2 poly);
kVsFx(k32u)    kL3dPolynomial2_Order(kL3dPolynomial2 poly, k32u index);
kVsFx(kStatus) kL3dPolynomial2_Assign(kL3dPolynomial2 poly,kL3dPolynomial2 src);
kVsFx(kStatus) kL3dPolynomial2_Add(kL3dPolynomial2 poly1, kL3dPolynomial2 poly2, kL3dPolynomial2 result);
kVsFx(kStatus) kL3dPolynomial2_Sub(kL3dPolynomial2 poly1, kL3dPolynomial2 poly2, kL3dPolynomial2 result);
kVsFx(kStatus) kL3dPolynomial2_Set(kL3dPolynomial2 poly, const k64f* coeffs, k32u order0 ,k32u order1);
kVsFx(k64f*)   kL3dPolynomial2_Coeffs(kL3dPolynomial2 poly);

kVsFx(k32u)    kL3dPolynomial2_ItemCount(k32u order0, k32u order1);

#endif /* #ifndef LMITECH_KVISION_L3D_POLYNOMIAL2_H_INCLUDED */
