#ifndef LMITECH_KVISION_L3D_NODEHEALTHHISTORY_H_INCLUDED
#define LMITECH_KVISION_L3D_NODEHEALTHHISTORY_H_INCLUDED

#include <kFireSync/kFsApi.h>
#include <kVision/L3d/kL3dCommon.h>

#define kL3D_NODE_HEALTH_HISTORY_FILE_NAME    "/temp/HealthHistory.kdat"

typedef kPointer kL3dNodeHealthHistory;

kVsFx(kStatus) kL3dNodeHealthHistory_Construct(kL3dNodeHealthHistory* history, kSize count);
kVsFx(kStatus) kL3dNodeHealthHistory_Load(kL3dNodeHealthHistory* history, kNode node, const kChar* fileName);
kVsFx(kStatus) kL3dNodeHealthHistory_Store(kL3dNodeHealthHistory history, const kChar* filename);
kVsFx(kStatus) kL3dNodeHealthHistory_StoreBytes(kL3dNodeHealthHistory history, kArray1* output);
kVsFx(kStatus) kL3dNodeHealthHistory_Destroy(kL3dNodeHealthHistory history);

kVsFx(kSize) kL3dNodeHealthHistory_Count(kL3dNodeHealthHistory history);

kVsFx(k64s*) kL3dNodeHealthHistory_TimestampAt(kL3dNodeHealthHistory history, kSize index);
kVsFx(k64s*) kL3dNodeHealthHistory_TemperatureIntAt(kL3dNodeHealthHistory history, kSize index);
kVsFx(k64s*) kL3dNodeHealthHistory_TemperatureExtAt(kL3dNodeHealthHistory history, kSize index);

#endif  /* #ifndef LMITECH_KVISION_L3D_NODEHEALTHHISTORY_H_INCLUDED */
