#ifndef kL3D_LVDS_IMAGE_ERRORS_BLOCK_X_H_INCLUDED
#define kL3D_LVDS_IMAGE_ERRORS_BLOCK_X_H_INCLUDED

#define kL3D_LVDS_IMAGE_ERRORS_BLOCK_DESCRIPTION            "Detects image errors by looking at the test pattern."

#include <kFireSync/Pipe/kPxPort.h>
#include <kVision/L3d/kL3dLvdsImageErrorsBlockInfo.h>

typedef enum
{
    kL3D_LVDS_IMAGE_ERRORS_BLOCK_IN_IMAGE = 0,
    kL3D_LVDS_IMAGE_ERRORS_BLOCK_OUT_RESULTS= 1,
    kL3D_LVDS_IMAGE_ERRORS_BLOCK_OUT_DESCRIPTION = 2
} kL3dLvdsImageErrorsBlockPort;

typedef struct kL3dLvdsImageErrorsBlockClass
{
    kPxBlockClass base;
    kAlloc alloc;

    kSize frameErrorCount;

    kSize noiseTolerance;
    kSize pixelTolerance;
    kSize sumTolerance;

    kSize pixelDifferenceCount;
    kSize pixelDifferenceSum;

    kArrayList testPattern;
    kString descriptionString;

    kPort inImage;
    kPort outResults;
    kPort outDescription;

} kL3dLvdsImageErrorsBlockClass;

kDeclareClassEx(kVs, kL3dLvdsImageErrorsBlock, kPxBlock)


kVsFx(const kChar*) kL3dLvdsImageErrorsBlock_VDescription();
kVsFx(kStatus) kL3dLvdsImageErrorsBlock_VOnSetup(kL3dLvdsImageErrorsBlock block);
kVsFx(kStatus) kL3dLvdsImageErrorsBlock_VOnStart(kL3dLvdsImageErrorsBlock block);
kVsFx(kStatus) kL3dLvdsImageErrorsBlock_VOnStop(kL3dLvdsImageErrorsBlock block);
kVsFx(kStatus) kL3dLvdsImageErrorsBlock_VOnReceive(kL3dLvdsImageErrorsBlock block, kPxPort port, kMsgSet msg);


kStatus kL3dLvdsImageErrorsBlock_ComparePattern(kL3dLvdsImageErrorsBlock block, kImage image);
kStatus kL3dLvdsImageErrorsBlock_FindPattern(kL3dLvdsImageErrorsBlock block, kImage image);
kStatus kL3dLvdsImageErrorsBlock_GenerateOutput(kL3dLvdsImageErrorsBlock block, kDataTree* output);

#endif /* kL3D_LVDS_IMAGE_ERRORS_BLOCK_X_H_INCLUDED */
