#ifndef LMITECH_KVISION_L3D_LINECALBLOCKINFO_H_INCLUDED
#define LMITECH_KVISION_L3D_LINECALBLOCKINFO_H_INCLUDED 

#include <kVision/L3d/kL3dCommon.h>

#define kL3D_LINE_CAL_BLOCK_NAME                 "3D_LineCal"
#define kL3D_LINE_CAL_BLOCK_TYPE_NAME            "kL3dLineCalBlock"

#define kL3D_LINE_CAL_BLOCK_INPUT_NAME           "Input"
#define kL3D_LINE_CAL_BLOCK_OUTDATA_NAME         "OutData"
#define kL3D_LINE_CAL_BLOCK_OUTPLOT_NAME         "OutPlot"

typedef enum
{
    kL3D_LINE_CAL_BLOCK_OUTDATA = 0,
    kL3D_LINE_CAL_BLOCK_OUTPLOT = 1,
    kL3D_LINE_CAL_BLOCK_INPUT_BEGIN = 2
} kL3dLineCalBlockPort;

typedef kPointer kL3dLineCalBlockInfo;

kVsFx(kStatus) kL3dLineCalBlockInfo_Construct(kL3dLineCalBlockInfo * info, k32u stateCount);
kVsFx(kStatus) kL3dLineCalBlockInfo_Load(kL3dLineCalBlockInfo * info, kXml xml);
kVsFx(kStatus) kL3dLineCalBlockInfo_Destroy(kL3dLineCalBlockInfo info);
kVsFx(kStatus) kL3dLineCalBlockInfo_Store(kL3dLineCalBlockInfo info, kXml* xml);

kVsFx(kStatus) kL3dLineCalBlockInfo_Read(kL3dLineCalBlockInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kL3dLineCalBlockInfo_Write(kL3dLineCalBlockInfo info, kXml xml, kXmlItem item);

kVsFx(k32u) kL3dLineCalBlockInfo_StateCount(kL3dLineCalBlockInfo info);
kVsFx(k32u) kL3dLineCalBlockInfo_LineCount(kL3dLineCalBlockInfo info);

kVsFx(kBool) kL3dLineCalBlockInfo_IsColumnBased(kL3dLineCalBlockInfo info);
kVsFx(k32u) kL3dLineCalBlockInfo_ImageWidth(kL3dLineCalBlockInfo info);
kVsFx(k32u) kL3dLineCalBlockInfo_ImageHeight(kL3dLineCalBlockInfo info);

kVsFx(kArrayList) kL3dLineCalBlockInfo_StateLines(kL3dLineCalBlockInfo info, k32u stateIndex);
kVsFx(k32u) kL3dLineCalBlockInfo_StateId(kL3dLineCalBlockInfo info, k32u stateIndex);

kVsFx(k32u) kL3dLineCalBlockInfo_MaxSegmentGap(kL3dLineCalBlockInfo info);
kVsFx(k64f) kL3dLineCalBlockInfo_MinSegmentRatio(kL3dLineCalBlockInfo info);
kVsFx(k32u) kL3dLineCalBlockInfo_SegmentSpotWindow(kL3dLineCalBlockInfo info);

kVsFx(kStatus) kL3dLineCalBlockInfo_SetStateCount(kL3dLineCalBlockInfo info, k32u stateCount);
kVsFx(kStatus) kL3dLineCalBlockInfo_SetLineCount(kL3dLineCalBlockInfo info, k32u lineCount);
kVsFx(kStatus) kL3dLineCalBlockInfo_SetColumnBased(kL3dLineCalBlockInfo info, kBool columnBased);
kVsFx(kStatus) kL3dLineCalBlockInfo_SetImageWidth(kL3dLineCalBlockInfo info, k32u imageWidth);
kVsFx(kStatus) kL3dLineCalBlockInfo_SetImageHeight(kL3dLineCalBlockInfo info, k32u imageHeight);

kVsFx(kStatus) kL3dLineCalBlockInfo_SetMaxSegmentGap(kL3dLineCalBlockInfo info, k32u gap);
kVsFx(kStatus) kL3dLineCalBlockInfo_SetMinSegmentRatio(kL3dLineCalBlockInfo info, k64f ratio);
kVsFx(kStatus) kL3dLineCalBlockInfo_SetSegmentSpotWindow(kL3dLineCalBlockInfo info, k32u window);

kVsFx(kStatus) kL3dLineCalBlockInfo_SetStateLines(kL3dLineCalBlockInfo info, k32u stateIndex, k32u* values, k32u count);
kVsFx(kStatus) kL3dLineCalBlockInfo_SetStateId(kL3dLineCalBlockInfo info, k32u stateIndex, k32u id);

#endif /* #ifndef LMITECH_KVISION_L3D_LINECALBLOCKINFO_H_INCLUDED */
