#ifndef LMITECH_KVISION_L3D_DETECTIONBLOCKINFO_H_INCLUDED
#define LMITECH_KVISION_L3D_DETECTIONBLOCKINFO_H_INCLUDED 

#include <kVision/L3d/kL3dCommon.h>

#define kL3D_DETECTION_BLOCK_NAME             "3D_Detection"
#define kL3D_DETECTION_BLOCK_TYPE_NAME        "kL3dDetectionBlock"

#define kL3D_DETECTION_BLOCK_INRANGES_NAME    "InRanges"
#define kL3D_DETECTION_BLOCK_OUTMAP_NAME      "OutMap"
#define kL3D_DETECTION_BLOCK_OUTMESH_NAME     "OutMesh"

typedef enum
{
    kL3D_DETECTION_BLOCK_INRANGES = 0,
    kL3D_DETECTION_BLOCK_OUTMAP   = 1,
    kL3D_DETECTION_BLOCK_OUTMESH  = 2
} kL3dDetectionBlockPort;

typedef kPointer kL3dDetectionBlockInfo;

kVsFx(kStatus) kL3dDetectionBlockInfo_Construct(kL3dDetectionBlockInfo * info);
kVsFx(kStatus) kL3dDetectionBlockInfo_Load(kL3dDetectionBlockInfo * info, kXml xml);
kVsFx(kStatus) kL3dDetectionBlockInfo_Destroy(kL3dDetectionBlockInfo info);
kVsFx(kStatus) kL3dDetectionBlockInfo_Store(kL3dDetectionBlockInfo info, kXml* xml);

kVsFx(kStatus) kL3dDetectionBlockInfo_Read(kL3dDetectionBlockInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kL3dDetectionBlockInfo_Write(kL3dDetectionBlockInfo info, kXml xml, kXmlItem item);

kVsFx(kL3dScanDomain) kL3dDetectionBlockInfo_Domain(kL3dDetectionBlockInfo info);
kVsFx(k64f) kL3dDetectionBlockInfo_DomainResolution(kL3dDetectionBlockInfo info);
kVsFx(k64f) kL3dDetectionBlockInfo_RangeResolution(kL3dDetectionBlockInfo info);
kVsFx(k64f) kL3dDetectionBlockInfo_XStart(kL3dDetectionBlockInfo info);
kVsFx(k64f) kL3dDetectionBlockInfo_XStep(kL3dDetectionBlockInfo info);
kVsFx(k32u) kL3dDetectionBlockInfo_XCount(kL3dDetectionBlockInfo info);
kVsFx(k64f) kL3dDetectionBlockInfo_YStep(kL3dDetectionBlockInfo info);
kVsFx(k32u) kL3dDetectionBlockInfo_MinSpots(kL3dDetectionBlockInfo info);
kVsFx(k32s) kL3dDetectionBlockInfo_TriggerInput(kL3dDetectionBlockInfo info);
kVsFx(k64f) kL3dDetectionBlockInfo_MaxWidth(kL3dDetectionBlockInfo info);
kVsFx(k64f) kL3dDetectionBlockInfo_EdgeMargin(kL3dDetectionBlockInfo info);

kVsFx(kStatus) kL3dDetectionBlockInfo_SetDomain(kL3dDetectionBlockInfo info, kL3dScanDomain domain);
kVsFx(kStatus) kL3dDetectionBlockInfo_SetDomainResolution(kL3dDetectionBlockInfo info, k64f resolution);
kVsFx(kStatus) kL3dDetectionBlockInfo_SetRangeResolution(kL3dDetectionBlockInfo info, k64f resolution);
kVsFx(kStatus) kL3dDetectionBlockInfo_SetXStart(kL3dDetectionBlockInfo info,k64f xStart);
kVsFx(kStatus) kL3dDetectionBlockInfo_SetXStep(kL3dDetectionBlockInfo info, k64f xStep);
kVsFx(kStatus) kL3dDetectionBlockInfo_SetXCount(kL3dDetectionBlockInfo info, k32u count); 
kVsFx(kStatus) kL3dDetectionBlockInfo_SetYStep(kL3dDetectionBlockInfo info, k64f yStep);
kVsFx(kStatus) kL3dDetectionBlockInfo_SetMinSpots(kL3dDetectionBlockInfo info, k32u minSpots);
kVsFx(kStatus) kL3dDetectionBlockInfo_SetTriggerInput(kL3dDetectionBlockInfo info, k32s triggerInput);
kVsFx(kStatus) kL3dDetectionBlockInfo_SetMaxWidth(kL3dDetectionBlockInfo info, k64f maxWidth);
kVsFx(kStatus) kL3dDetectionBlockInfo_SetEdgeMargin(kL3dDetectionBlockInfo info, k64f edgeMargin);

#endif /* #ifndef LMITECH_KVISION_L3D_DETECTIONBLOCKINFO_H_INCLUDED */
