#ifndef LMITECH_KVISION_L3D_COMMON_H_INCLUDED
#define LMITECH_KVISION_L3D_COMMON_H_INCLUDED

#include <kFireSync/kFsDef.h>
#include <kVision/Common/kVision.h>

#define kL3D_CAL_CONFIDENCE_STDEV   (2)

#define kL3D_DEFAULT_STATE_COUNT               (1)
#define kL3D_DEFAULT_LINE_COUNT                (1)
#define kL3D_DEFAULT_VIEW_COUNT                (1)
#define kL3D_DEFAULT_MAX_SEGMENT_GAP           (10)
#define kL3D_DEFAULT_MIN_SEGMENT_RATIO         (0.4000)
#define kL3D_DEFAULT_SPOT_WINDOW               (10)
#define kL3D_MAX_IMAGE_WIDTH                   (4096)
#define kL3D_MAX_MAXFOUND                      (16384)

typedef enum
{
    kL3D_SCAN_DOMAIN_TIME,
    kL3D_SCAN_DOMAIN_POSITION,
    kL3D_SCAN_DOMAIN_FRAME
} kL3dScanDomain;

typedef enum
{
    kL3D_INTERPOLATION_NEAREST_NEIGHBOUR,
    kL3D_INTERPOLATION_LINEAR
} kL3dIntepolationType;

typedef enum
{
    kL3D_VIEW_MERGE_FILL,
    kL3D_VIEW_MERGE_VALIDATE,
    kL3D_VIEW_MERGE_AVERAGE
} kL3dViewMergeType;

typedef enum
{
    kL3D_ORIENTATION_DEFAULT,
    kL3D_ORIENTATION_INVERTED
} kL3dViewOrientation;

typedef enum
{
    kL3D_CALIBRATION_VIEW,
    kL3D_CALIBRATION_NOTCH
} kL3dCalibrationType;

typedef enum
{
    kL3D_CAL_POLYNOMIAL = 0,
    kL3D_CAL_RANGE      = 1
} kL3dCalDataType;

typedef enum
{
    kL3D_NOTCH_SAMPLING_SPOT      = 0,
    kL3D_NOTCH_SAMPLING_IMAGE     = 1,
    kL3D_NOTCH_SAMPLING_SIMULATED = 2
} kL3dNotchSamplingType;

typedef struct kL3dPolynomialFitParams 
{
    k32u maxOrder;
    k64f targetError;
    k64f orderPenalty;
} kL3dPolynomialFitParams;

typedef struct kL3dCameraWindow 
{
    k32s x;
    k32s y;
    k32u width;
    k32u height;
    k32u xSubsampling;
    k32u ySubsampling;
} kL3dCameraWindow;

typedef enum
{
    kL3D_AXIS_X,
    kL3D_AXIS_Y,
    kL3D_AXIS_Z
} kL3dCoordAxis;

typedef enum
{
    kL3D_PRNU_CORRECTION_NONE,
    kL3D_PRNU_CORRECTION_SOFTWARE,
    kL3D_PRNU_CORRECTION_HARDWARE
} kL3dPrnuCorrectionType;

typedef enum
{
    kL3D_LOOKUP_SINGULAR_LINEAR,
    kL3D_LOOKUP_LINEAR_CUBIC
} kL3dLookupMethod;

typedef enum
{
    kL3D_SPOT_TYPE_SPOT             = 0,
    kL3D_SPOT_TYPE_FPGA_SPOT        = 1,
    kL3D_SPOT_TYPE_FPGA_WIDE_SPOT   = 2
} kL3dSpotType;

#include <kVision/L3d/kL3dCommon.x.h>

#endif /* #ifndef LMITECH_KVISION_L3D_COMMON_H_INCLUDED */
