#ifndef LMITECH_KVISION_L3D_CHARTPLOTTER_H_INCLUDED
#define LMITECH_KVISION_L3D_CHARTPLOTTER_H_INCLUDED

#include <kFireSync/Data/kGraphic.h>
#include <kFireSync/Data/kPlot.h>
#include <kFireSync/Data/kSpot.h>
#include <kVision/Common/kPolynomial.h>
#include <kVision/L3d/kL3dCommon.h>
#include <kVision/L3d/kL3dTransform2d.h>

typedef kObject kL3dChartPlotter;

typedef enum
{
    kL3D_CURVE_STYLE_LINE,
    kL3D_CURVE_STYLE_POINTS,
    kL3D_CURVE_STYLE_CROSSES,
    kL3D_CURVE_STYLE_CONNECTED_POINTS
} kL3dChartPlotterCurveStyle;

kDeclareValueEx(kVs, kL3dChartPlotterCurveStyle, kValue)

// If plot is kNULL, no other functions should be called until kL3dChartPlotter_StartPlot is called with a valid kPlot
kVsFx(kStatus) kL3dChartPlotter_Construct(kL3dChartPlotter* plotter, kPlot plot, kAlloc allocator);
kVsFx(kPlot)   kL3dChartPlotter_Plot(kL3dChartPlotter plotter);
kVsFx(kStatus) kL3dChartPlotter_StartPlot(kL3dChartPlotter plotter, kPlot plot);

kVsFx(kStatus) kL3dChartPlotter_StartLayer(kL3dChartPlotter plotter, const kChar* name);
kVsFx(kStatus) kL3dChartPlotter_EndLayer(kL3dChartPlotter plotter);

kVsFx(kStatus) kL3dChartPlotter_SetWorld(kL3dChartPlotter plotter, k64f x, k64f y, k64f width, k64f height);
kVsFx(kStatus) kL3dChartPlotter_AutoSizePlot(kL3dChartPlotter plotter);

kVsFx(kStatus) kL3dChartPlotter_SetTransform(kL3dChartPlotter plotter, const kL3dTransform2d* transform);
kVsFx(kStatus) kL3dChartPlotter_ResetTransform(kL3dChartPlotter plotter);

kVsFx(kStatus) kL3dChartPlotter_LabelSeries(kL3dChartPlotter plotter, const kChar* format, ...);
kVsFx(kStatus) kL3dChartPlotter_SetTitles(kL3dChartPlotter plotter, const kChar* plotTitle, const kChar* xTitle, const kChar* yTitle);

kVsFx(kStatus) kL3dChartPlotter_SetPointSize(kL3dChartPlotter plotter, k64f size);
kVsFx(kStatus) kL3dChartPlotter_SetLineWidth(kL3dChartPlotter plotter, k64f width);
kVsFx(kStatus) kL3dChartPlotter_SetCurveStyle(kL3dChartPlotter plotter, kL3dChartPlotterCurveStyle style);

/**
  * Adds an image to the plot.
  *
  * @param plotter  the kL3dCharPlotter object (a plot must have been passed via the constructor or StartPlot)
  * @param image   a kImage object - this object is owned by the caller and cloned by the function
  */
kVsFx(kStatus) kL3dChartPlotter_PlotImage(kL3dChartPlotter plotter, kImage image);

kVsFx(kStatus) kL3dChartPlotter_PlotPoints32f(kL3dChartPlotter plotter, const kPoint32f* points, kSize count, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotCoords32f(kL3dChartPlotter plotter, const k32f* x, const k32f* y, kSize count, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotSteps32f(kL3dChartPlotter plotter, const k32f* steps, kSize count, kColor color);

kVsFx(kStatus) kL3dChartPlotter_PlotPoints3d64f(kL3dChartPlotter plotter, const kPoint3d64f* points, kSize count, k32u xChannel, k32u yChannel, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotPoints64f(kL3dChartPlotter plotter, const kPoint64f* points, kSize count, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotCoords64f(kL3dChartPlotter plotter, const k64f* x, const k64f* y, kSize count, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotSteps64f(kL3dChartPlotter plotter, const k64f* steps, kSize count, kColor color);

kVsFx(kStatus) kL3dChartPlotter_PlotPoints3d16s(kL3dChartPlotter plotter, const kPoint3d16s* points, kSize count, k32u xChannel, k32u yChannel, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotPoints16s(kL3dChartPlotter plotter, const kPoint16s* points, kSize count, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotCoords16s(kL3dChartPlotter plotter, const k16s* x, const k16s* y, kSize count, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotSteps16s(kL3dChartPlotter plotter, const k16s* steps, kSize count, kColor color);

kVsFx(kStatus) kL3dChartPlotter_PlotPoints32s(kL3dChartPlotter plotter, const kPoint32s* points, kSize count, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotCoords32s(kL3dChartPlotter plotter, const k32s* x, const k32s* y, kSize count, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotSteps32s(kL3dChartPlotter plotter, const k32s* steps, kSize count, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotSteps8u(kL3dChartPlotter plotter, const k8u* steps, kSize count, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotSteps8s(kL3dChartPlotter plotter, const k8s* steps, kSize count, kColor color);

kVsFx(kStatus) kL3dChartPlotter_PlotSpots(kL3dChartPlotter plotter, const kSpot* points, kSize count, kBool columnBased, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotFpgaSpots(kL3dChartPlotter plotter, const kFpgaSpot* points, kSize count, kBool columnBased, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotFpga2iSpots(kL3dChartPlotter plotter, const kFpgaSpot2i* points, kSize count, kBool columnBased, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotFpgaSpotEnds(kL3dChartPlotter plotter, const kFpgaSpot* points, kSize count, kAcgSpotFormat spotFormat, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotFpgaWideSpots(kL3dChartPlotter plotter, const kFpgaWideSpot* points, kSize count, kBool columnBased, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotFpgaWideSpotEnds(kL3dChartPlotter plotter, const kFpgaWideSpot* points, kSize count, kAcgSpotFormat spotFormat, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotSpotStrengths(kL3dChartPlotter plotter, const kSpot* points, kSize count, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotArrow64f(kL3dChartPlotter plotter, const kPoint64f* p0, const kPoint64f* p1, k64f tipLengthFraction, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotRect64f(kL3dChartPlotter plotter, const kRect64f * rect, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotRect32s(kL3dChartPlotter plotter, const kRect32s * rect, kColor color);
kVsFx(kStatus) kL3dChartPlotter_PlotFunction(kL3dChartPlotter plotter, kPolynomial function, k64f begin, k64f end, kSize count, kColor color);

kVsFx(kStatus) kL3dChartPlotter_PlotLine64f(kL3dChartPlotter plotter, const kPoint3d64f* line, const kRect64f* bound, kColor color);

kVsFx(kStatus) kL3dChartPlotter_PlotText(kL3dChartPlotter plotter, const kChar* message, const kPoint32f location, kColor color, k32f height, kAlignment alignment);

kVsFx(kStatus) kL3dChartPlotter_Plot2DSpots(kL3dChartPlotter plotter, const kSpot2* points, kSize count, kColor color);

kVsFx(k64f)    kL3dChartPlotter_MinX(kL3dChartPlotter plotter);
kVsFx(k64f)    kL3dChartPlotter_MinY(kL3dChartPlotter plotter);
kVsFx(k64f)    kL3dChartPlotter_MaxX(kL3dChartPlotter plotter);
kVsFx(k64f)    kL3dChartPlotter_MaxY(kL3dChartPlotter plotter);

#include <kVision/L3d/kL3dChartPlotter.x.h>

#endif /* #ifndef LMITECH_KVISION_L3D_CHARTPLOTTER_H_INCLUDED */
