#ifndef LMITECH_KVISION_L3D_CALDATA_H_INCLUDED
#define LMITECH_KVISION_L3D_CALDATA_H_INCLUDED

#include <kVision/L3d/kL3dCommon.h>
#include <kFireSync/Data/kDataTree.h>

typedef kObject kL3dCalData;

/**
* Stores the cal data in a kDataTree at a kDataTreeItem.
*
* @public              @memberof kL3dCalData
* @param   data        The kL3dCalData object.
* @param   tree        Tree object.
* @param   item        Tree item.
* @return              Operation status.
*/
kVsFx(kStatus) kL3dCalData_Store(kL3dCalData data, kDataTree tree, kDataTreeItem item);

/**
* Shallow copies a source kL3dCalData. The destination will have it's internal data disposed prior
* to the copy being performed.
*
* @public              @memberof kL3dCalData
* @param   data        Destination object.
* @param   source      Source object.
* @return              Operation status.
*/
kVsFx(kStatus) kL3dCalData_Assign(kL3dCalData data, kL3dCalData source);

/**
* Gets the type of the kL3dCalData.
*
* @public              @memberof kL3dCalData
* @param   data        kL3dCalData object.
* @return              Cal data type.
*/
kVsFx(kL3dCalDataType) kL3dCalData_Type(kL3dCalData data);

#include <kVision/L3d/kL3dCalData.x.h>

#endif /* #ifndef LMITECH_KVISION_L3D_CALDATA_H_INCLUDED */
