/**
* @file    kG3dPolynomMap.x.h
* @brief   Declares the kG3dPolynomMap class.
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_kG3D_POLYNOMMAP_X_H
#define KVISION_kG3D_POLYNOMMAP_X_H

#define KVISION_kG3D_POLYNOMMAP_MAX_THREAD_COUNT 16

typedef struct kG3dPolynomMapParams
{
    k64f xyScale;
    k64f zScale;
    k32s order;
    k32s order2;
    k32s step;
}kG3dPolynomMapParams;

typedef struct kG3dPolynomMapClass
{
    kObjectClass base;
    kG3dPolynomMapParams params;
    k32s paraSize;
    k32s matSize;
    k32s potencyLen;

    k32s paraSize2;
    k32s matSize2;
    k32s potencyLen2;

    k32s planeCount;
    k32s imageSizeY;
    k32s imageSizeX;
    k32s polynLineDegree;
    
    kArray1 indexX;
    kArray1 indexY;
    kArray1 mat;
    kArray1 mat2;
    kArray1 inv;
    kArray1 inv2;
    kArray1 vec;
    kArray1 vec2;
    kArray2 xyValue;
    kArray2 zValue;
    kArray2 linePolyn;

    kVsJobQueue jobQueue;
    k32s threadCount;
    kArray1 jobVec[KVISION_kG3D_POLYNOMMAP_MAX_THREAD_COUNT];
    kArray1 jobVec2[KVISION_kG3D_POLYNOMMAP_MAX_THREAD_COUNT];
    kArray2 jobXYValue[KVISION_kG3D_POLYNOMMAP_MAX_THREAD_COUNT];
    kArray2 jobZValue[KVISION_kG3D_POLYNOMMAP_MAX_THREAD_COUNT];
    kArray1 jobIndexX[KVISION_kG3D_POLYNOMMAP_MAX_THREAD_COUNT];
    kArray1 jobIndexY[KVISION_kG3D_POLYNOMMAP_MAX_THREAD_COUNT];
    kG3dPolynomial polyX[KVISION_kG3D_POLYNOMMAP_MAX_THREAD_COUNT];
    kG3dPolynomial polyY[KVISION_kG3D_POLYNOMMAP_MAX_THREAD_COUNT];
    kArray2 data;
    kArray2 valid;
    k8u bit;
    k32s stepX, stepY;

}kG3dPolynomMapClass;

kDeclareClassEx(kVs, kG3dPolynomMap, kObject)

kStatus kG3dPolynomMap_Init(kG3dPolynomMap polynMap, kType classType, kAlloc alloc);
kVsFx(kStatus) kG3dPolynomMap_VRelease(kG3dPolynomMap polynMap);
kVsFx(kStatus) kG3dPolynomMap_StandardDeviation(kG3dPolynomMap polynMap, kArray2 data, kArray2 valid, kG3dPolynomial polynomial, k64f* dev, k32s*validCount,
    kS3dArray2DataType inType, kS3dArray2DataType outType, k32s weight);

kStatus kG3dPolynomMap_CreatePolynMatrix(kG3dPolynomMap polynMap, kArray2 data, kS3dArray2DataType type);
kStatus kG3dPolynomMap_CreateMatrixXYPoint3d(kG3dPolynomMap polynMap, kArray2 data);
kStatus kG3dPolynomMap_CreateValidPolynMatrix(kG3dPolynomMap polynMap, kArray2 data, kArray2 valid, k32f weight, kS3dArray2DataType type);
kStatus kG3dPolynomMap_CreateMatrixFromMapXYZ(kG3dPolynomMap polynMap, kArray2 mapX, kArray2 mapY, kArray2 data, kArray2 valid);
kStatus kG3dPolynomMap_CreatePolynomialMatrixFromParaXY(kG3dPolynomMap polynMap, kArray2 data, kG3dPolynomial polynX, kG3dPolynomial polynY);
kStatus kG3dPolynomMap_FillPolynomalMatrix(kG3dPolynomMap polynMap);
kStatus kG3dPolynomMap_SolveEquations(kG3dPolynomMap polynMap, kG3dPolynomial polynomial);
kStatus kG3dPolynomMap_SolveTwoMapEquations(kG3dPolynomMap polynMap, kG3dPolynomial polynomialX, kG3dPolynomial polynomialY);
kStatus kG3dPolynomMap_WeightedMapValue(kG3dPolynomMap polynMap, kArray2 data, kArray2 valid, kG3dPolynomial polynomial, k32f f1, k32f f2, kS3dArray2DataType type);
kStatus kG3dPolynomMap_DrawDerivativeMap(kG3dPolynomMap polynMap, kArray2 data, kArray2 valid, kG3dPolynomial polynomial, k32f wavelength, kS3dArray2DataType type);
kStatus kG3dPolynomMap_DrawValidPolynomal(kG3dPolynomMap polynMap, kArray2 data, kArray2 valid, kG3dPolynomial polynomial, kS3dArray2DataType type);
kStatus kG3dPolynomMap_CreateMatrixPolynPoint3d(kG3dPolynomMap polynMap, kArray1 data);
kStatus kG3dPolynomMap_CreateMatrixWeightedPoint3d(kG3dPolynomMap polynMap, kArray2 data);
kStatus kG3dPolynomMap_CreateValidMatrix(kG3dPolynomMap polynMap, kArray2 data, kArray2 valid, kS3dArray2DataType type);
kStatus kG3dPolynomMap_SetMatrixDerivative3order(kG3dPolynomMap polynMap, kArray2 data, kArray2 valid, kG3dPolynomial polynomial, k32f wavelength, kS3dArray2DataType type);
kStatus kG3dPolynomMap_CreateMatrixFromPolynCoord(kG3dPolynomMap polynMap, kG3dPolynomial polynZ, kG3dPolynomial polynX, kG3dPolynomial polynY, k64f gScale, k32s imageSizeX, k32s imageSizeY);
kStatus kG3dPolynomMap_CreateMatrixFromGridPoints(kG3dPolynomMap polynMap, kArray2 data, k64f centerX, k64f centerY);
kStatus kG3dPolynomMap_SolvePolynMapEquations(kG3dPolynomMap polynMap, kG3dPolynomial polynomial);
kStatus kG3dPolynomMap_AddPhaseDistorMatrixItem(kG3dPolynomMap polynMap, kArray1 viewPoint, kArray1 phaseX);
kStatus kG3dPolynomMap_CreateDeformationPolynMatrix(kG3dPolynomMap polynMap, kArray1 data, k32s order, k32s direction);
kStatus kG3dPolynomMap_CalculateDeformationDeviation(kG3dPolynomMap polynMap, kArray1 data, kG3dPolynomial polynomial, k64f *dev, k32s direction, kBool outlier);

kStatus kG3dPolynomMap_CreatePolynValidMapMatrix32s(kG3dPolynomMap polynMap, kArray2 data, kArray2 valid, kPoint3d64f scale, k8u bit);
kStatus kG3dPolynomMap_FillPolynValidMap32s(kG3dPolynomMap polynMap, kArray2 data, kArray2 valid, kG3dPolynomial polynomial, kPoint3d64f scale, k8u bit, kBool outputLaw);

kStatus kG3dPolynomMap_AddMatrixWeightedValidPoint3dY(kG3dPolynomMap polynMap, kArray2 data, kArray2 valid, kG3dPolynomial polynomial, k8u bit);
kStatus kG3dPolynomMap_AddMatrixWeightedValidPoint3dX(kG3dPolynomMap polynMap, kArray2 data, kArray2 valid, kG3dPolynomial polynomial, k8u bit);

kStatus kCall kG3dPolynomMap_CreateMatrixWeightedValidPoint3dXHandler(kG3dPolynomMap polynMap, k64u id);
kStatus kCall kG3dPolynomMap_PolynomialMatrixFromParaXYHandler(kG3dPolynomMap polynMap, k64u id);
kStatus kCall kG3dPolynomMap_CreateMatrixWeightedValidPoint3dYHandler(kG3dPolynomMap polynMap, k64u id);

//

#endif /* #ifndef KVISION_kG3D_POLYNOMMAP_X_H */
