/**
* @file    kG3dJumpContour.x.h
* @brief   
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_kS3D_JUMP_CONTOUR_X_H
#define KVISION_kS3D_JUMP_CONTOUR_X_H

#define kS3DJUMP_CONTOUR_DEFAULT_LUT_WIDTH       64
#define kS3DJUMP_CONTOUR_DEFAULT_TOLERANCE_FACTOR  0.2
#define kS3DJUMP_CONTOUR_DEFAULT_TOLERANCE_FACTOR2  0.8
#define kS3DJUMP_CONTOUR_DEFAULT_TOLERANCE_FACTOR3  0.5
#define kS3DJUMP_CONTOUR_DEFAULT_TOLERANCE_MAX_FACTOR  400

#define kS3DJUMP_COSINE_TABLE_MAXIMUM  1024

typedef struct kG3dJumpContourClass
{
    kObjectClass base;
    kObject input;
    kArray2 inputHeightMap;
    kArray2 data;
    kArray2 tempMap;
    kArray2 value;
    kArray2 angle;
    kArray2 angleLuTab;
    kArray1 cosLuTab;

    kG3dContourTemplate mask;
    kG3dContourSegment segment;
    kG3dContourHistogram histogram;
    kG3dContourFitLine fitLine;
    kG3dContourClosedLine closedLine;
    k32s imageSizeX;
    k32s imageSizeY;
    k32s tabWidth;
    k32s AngleHistoCount;
    k64f tolFactor;
    k16s threshold;
    kPoint3d64f scale;
    kBool arrayUsed;
    k32s maxX;
    k32s maxY;
    k64s sum;
    k32s count;
    kArray1 borderPoints;
    kArray1 contourPoints;
    k32s lineCount;
    k32s curveCount;
    kG3dInputImagesOrder mode;
    kBool flipBmp;
    k32s sampleType;

    k32s sampleIndex;
    k32s repeatIndex;
    k64f positionTol;
} kG3dJumpContourClass;

kDeclareClassEx(kVs, kG3dJumpContour, kObject)

kStatus kG3dJumpContour_Init(kG3dJumpContour jumpCountur, kType classType, kAlloc alloc);

kVsFx(kStatus) kG3dJumpContour_VInitClone(kG3dJumpContour jumpCountur, kG3dJumpContour source, kAlloc allocator);
kVsFx(kSize)   kG3dJumpContour_VSize(kG3dJumpContour jumpCountur);
kVsFx(kStatus) kG3dJumpContour_VRelease(kG3dJumpContour jumpCountur);

kStatus kG3dJumpContour_ReleaseBuffer(kG3dJumpContour jumpCountur);
kStatus kG3dJumpContour_Setup(kG3dJumpContour jumpCountur, k32s mode);
kStatus kG3dJumpContour_DerivationMap(kG3dJumpContour jumpCountur);
kStatus kG3dJumpContour_SegmentMap(kG3dJumpContour jumpCountur, kBool isTemplate);
kStatus kG3dJumpContour_CalculateClosedContours(kG3dJumpContour jumpCountur);
kStatus kG3dJumpContour_StraightLinesHistogram(kG3dJumpContour jumpCountur);
kStatus kG3dJumpContour_CalculateStraightLines(kG3dJumpContour jumpCountur);
kStatus kG3dJumpContour_TemplateSegmentMap(kG3dJumpContour jumpCountur);
kStatus kG3dJumpContour_DrawMaskMap(kG3dJumpContour jumpCountur);
kStatus kG3dJumpContour_SearchClosedContours(kG3dJumpContour jumpCountur);
kStatus kG3dJumpContour_MedianMap5(kG3dJumpContour jumpCountur, kArray2 data);

#endif  /* KVISION_kS3D_JUMP_CONTOUR_X_H */
