/** 
 * @file    kSerialOutTest.x.h
 * 
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef LMITECH_KVISION_KSERIALOUT_TEST_X_H
#define LMITECH_KVISION_KSERIALOUT_TEST_X_H

#include <kFireSync/Action/kAxAction.h>
#include <kVision/Common/kSerialOutTestInfo.h>

#define kSERIAL_OUT_TEST_WRITE_THREAD_PRIORITY      (-2)
#define kSERIAL_OUT_TEST_WRITE_DATA_BATCH           (256)

/* 
 * kSerialOutTestStartAction
 */

typedef struct kSerialOutTestStartActionClass
{
    kAxActionClass base; 
} kSerialOutTestStartActionClass; 

kDeclareClassEx(kVs, kSerialOutTestStartAction, kAxAction)

kVsFx(const kChar*) kSerialOutTestStartAction_VDescription();
kVsFx(kStatus) kSerialOutTestStartAction_VInvoke(kSerialOutTestStartAction action, kObject input, kObject* output, kAlloc alloc);

/* 
 * kSerialOutTestStopAction
 */

typedef struct kSerialOutTestStopActionClass
{
    kAxActionClass base; 
} kSerialOutTestStopActionClass; 

kDeclareClassEx(kVs, kSerialOutTestStopAction, kAxAction)

kVsFx(const kChar*) kSerialOutTestStopAction_VDescription();
kVsFx(kStatus) kSerialOutTestStopAction_VInvoke(kSerialOutTestStopAction action, kObject input, kObject* output, kAlloc alloc);

/* 
 * kSerialOutTest
 */

typedef struct kSerialOutTestStatic
{
    kSystem system; 
    kNode node; 
    kSerialOut serialOut;
    kAtomic32s shouldQuit;
    kThread thread;
    k64u lastTarget;
    k32u outputData;
    kSize dataSize;
    k32u minData;
    k32u maxData;

    kSize serialIndex;
    kSerialOutMode mode;
    k64u delay;
    k64u period;
} kSerialOutTestStatic; 

kDeclareStaticClassEx(kVs, kSerialOutTest)

kVsFx(kStatus) xkSerialOutTest_InitStatic();
kVsFx(kStatus) xkSerialOutTest_ReleaseStatic();

kVsFx(kStatus) kSerialOutTest_OnWriteTimer(kPointer context);

kVsFx(kStatus) kSerialOutTest_Start(kSystem system, kNode node, kXml xml);
kVsFx(kStatus) kSerialOutTest_Stop(void);

#endif
