/** 
 * @file    kCpuStressTester.x.h
 * 
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef LMITECH_KVISION_STRESS_TEST_X_H
#define LMITECH_KVISION_STRESS_TEST_X_H

#include <kVision/Vs/kVsJobQueue.h>

#define kVISION_CUDA_PHASE_DECODER_TEST_BENCHARK_ITERATIONS     (10)
#define kVISION_CUDA_PHASE_DECODER_TEST_IMAGE_WIDTH             (2032)
#define kVISION_CUDA_PHASE_DECODER_TEST_IMAGE_HEIGHT            (1432)

#ifdef K_HAVE_CUDA
#define STRESS_CUDA_THREAD_COUNT                                (1)
#else
#define STRESS_CUDA_THREAD_COUNT                                (0)
#endif

#define STRESS_TOTAL_THREAD_COUNT                               (6) //Number of cores on TX2. Test is optimized for TX2
#define STRESS_CPU_THREAD_COUNT                                 (STRESS_TOTAL_THREAD_COUNT-STRESS_CUDA_THREAD_COUNT)


#ifdef K_HAVE_CUDA
typedef struct kGpuStressHelper
{
    kSize phaseCount;
    kObject phaseDecoderCuda;
    kArray2 outputCuda;
    kPointer outputBufferCuda;
    k64u processingTimeCuda;
    kArray1 imagesCuda;
    kObject dataTree;
    kCudaAlloc cudaAllocator;
    kArray1 tempBuffer;

} kGpuStressHelper; 
#endif

typedef struct kCpuStressTesterClass 
{
    kObjectClass base;
    kNode node;
    kAtomic32s stopTest;
    kVsJobQueue jobQueue;

} kCpuStressTesterClass;

kDeclareClassEx(kVs, kCpuStressTester, kObject);

kVsFx(kStatus) kCpuStressTester_Init(kCpuStressTester tester, kType classType, kNode node, kObject allocator);
kVsFx(kStatus) kCpuStressTester_VRelease(kCpuStressTester tester);

#define GMX_NODE_STRESS_TESTER(HANDLE) ((kCpuStressTesterClass*)(HANDLE))

#ifdef K_HAVE_CUDA
kVsFx(kStatus) kCpuStressTester_ConstructPhaseDecoderCuda(kGpuStressHelper* h);
kStatus kCall kCpuStressTester_StressGpu(kPointer context, k64u id);
kVsFx(kStatus) kCpuStressTester_GpuTestTeardown(kGpuStressHelper* h);
#endif
kStatus kCall kCpuStressTester_StressCpu(kPointer context, k64u id);


#endif
