/** 
 * @file    kZstdStream.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc.
 */
#ifndef K_ZSTD_STREAM_X_H
#define K_ZSTD_STREAM_X_H

typedef struct kZstdStreamClass
{   
    kStreamClass base; 
    
    k32s preset;                //preset used when opening compressor
    kStream stream;             //underlying stream

    kPointer outContext;        //zstd context (pointer to ZSTD_CStream), used for writing to underlying stream
    kPointer outBufferContext;  //output/write buffer context (pointer to ZSTD_outBuffer)
    kByte* outBuffer;           //output/write buffer, used between zstd and underlying stream

    kPointer inContext;         //zstd context (pointer to ZSTD_DStream), used for reading from underlying stream
    kPointer inBufferContext;   //input/read buffer context (pointer to ZSTD_inBuffer)
    kSize inBufferSize;         //size of the input/read buffer (if class owns the buffer)
    kByte* inBuffer;            //input/read buffer, used between zstd and underlying stream; only used if underlying stream lacks read buffer

    kBool isReadingFrame;       //kTRUE when a frame read has been started but not completed
    kBool isWritingFrame;       //kTRUE when a frame write has been started but not completed
    
} kZstdStreamClass;

kDeclareClassEx(kFs, kZstdStream, kStream)

kDeclareEnumEx(kFs, kZstdMode, kValue)
kDeclareEnumEx(kFs, kZstdPreset, kValue)

/* 
* Private methods. 
*/

kFsFx(kCompressionType) xkZstdStream_CompressionType();
kFsFx(kVersion) xkZstdStream_RequiredVersion();
kFsFx(kStatus) xkZstdStream_ConstructCompressor(kZstdStream* zStream, kStream stream, kBool isWriter, k32s level, kAlloc allocator);

kFsFx(k32s) xkZstdStream_InterpretLevel(k32s level);

kFsFx(kStatus) xkZstdStream_Init(kZstdStream zStream, kType type, kStream stream, kZstdMode mode, k32s level, kAlloc alloc); 
kFsFx(kStatus) xkZstdStream_VRelease(kZstdStream zStream);

kFsFx(kStatus) xkZstdStream_VReadSomeImpl(kZstdStream zStream, void* buffer, kSize minCount, kSize maxCount, kSize* bytesRead);
kFsFx(kStatus) xkZstdStream_VWriteImpl(kZstdStream zStream, const void* buffer, kSize size);
kFsFx(kStatus) xkZstdStream_VFlush(kZstdStream zStream);
kFsFx(kStatus) xkZstdStream_VSeek(kZstdStream zStream, k64s offset, kSeekOrigin origin);

kFsFx(kStatus) xkZstdStream_FillZstdInBuffer(kZstdStream zStream);

kFsFx(kStatus) xkZstdStream_FinishWrite(kZstdStream zStream, kBool isClosing);
kFsFx(kStatus) xkZstdStream_FinishRead(kZstdStream zStream, kBool isClosing);

#endif
