/** 
 * @file    kPacketSocket.x.h
 *
 * @internal
 * Copyright (C) 2017-2022 by LMI Technologies Inc.
 */
#ifndef K_PACKET_SOCKET_X_H
#define K_PACKET_SOCKET_X_H

/* 2x MAC address (12) + ethertype (4) */
#define kPACKET_SOCKET_MIN_PACKET_LEN 28

#if defined(K_WINDOWS) || defined(K_LINUX)

#   define kPACKET_SOCKET_WIN_DRIVER_PREFIX  ("\\Device\\NPF_")

#   define kPACKET_SOCKET_READ_TIMEOUT_MS          (0)
#   define kPACKET_SOCKET_SNAP_LEN                 (65536)

    typedef kPointer    (kDlCall *pcap_open_liveFx)(const char*, int, int, int, char*);
    typedef int         (kDlCall *pcap_sendpacketFx)(kPointer, const unsigned char*, int);
    typedef void        (kDlCall *pcap_closeFx)(kPointer);
    typedef int         (kDlCall *pcap_compileFx)(kPointer, kPointer, const char*, int, unsigned int);
    typedef int         (kDlCall *pcap_next_exFx)(kPointer, kPointer, const unsigned char**);
    typedef int         (kDlCall *pcap_setfilterFx)(kPointer, kPointer);
    typedef void        (kDlCall *pcap_freecodeFx)(kPointer);
    
    kFsFx(kStatus) kPacketSocket_CompileFilter(kPacketSocket sockt, k16u* protocols, kSize protocolCount);

#    if defined(K_WINDOWS)
        typedef kPointer    (kDlCall *pcap_geteventFx)(kPointer);
        typedef k32s        (kDlCall *pcap_setmintocopyFx)(kPointer, int);
#       define kPACKET_SOCKET_EVENT_FX_NAME "pcap_getevent"
#       define kPACKET_SOCKET_MINTOCOPY_DEF pcap_setmintocopyFx pcap_setmintocopyFn;
#       define kPACKET_SOCKET_LIB_NAME "wpcap"
#   else
        typedef int (kDlCall *pcap_geteventFx)(kPointer);
#       define kPACKET_SOCKET_EVENT_FX_NAME "pcap_get_selectable_fd"
#       define kPACKET_SOCKET_MINTOCOPY_DEF
#       define kPACKET_SOCKET_LIB_NAME "libpcap"
#   endif

#   if defined(K_LINUX)
    kStatus kPacketSocket_Gateway(const kChar* adapter, kIpAddress* gateway);
#   endif

#   define kPacketSocketPlatformFields()        \
        kPointer pcapHandle;                    

#   define kPacketSocketPlatformStaticFields()  \
        kDynamicLib pcapLib;                    \
        pcap_open_liveFx pcap_open_liveFn;      \
        pcap_sendpacketFx pcap_sendpacketFn;    \
        pcap_closeFx pcap_closeFn;              \
        pcap_compileFx pcap_compileFn;          \
        pcap_next_exFx pcap_next_exFn;          \
        pcap_setfilterFx pcap_setfilterFn;      \
        pcap_geteventFx pcap_geteventFn;        \
        pcap_freecodeFx pcap_freecodeFn;        \
        kPACKET_SOCKET_MINTOCOPY_DEF

    kFsFx(kStatus) kPacketSocket_FormatDrivername(kChar* dest, kSize capacity, const kChar* adapterName);
    kFsFx(kStatus) kPacketSocket_Wait(kPacketSocket socket, k64u timeout);

#elif defined (K_VX_KERNEL)

#   define kPacketSocketPlatformFields()        \
        kPointer cookie;                        \
        kPointer endObj;                        \
        kMsgQueue queue;                        \
        kPoolAlloc packetAlloc;                 \
        kArrayList protocols;

#   define kPacketSocketPlatformStaticFields() \
        kPointer dummy;

#   define kPACKET_SOCKET_BUFFER_SIZE              (1048576)

    kBool kPacketSocket_PassFilter(kPacketSocket sockt, kPointer pMblk);

#else

#   define kPacketSocketPlatformFields() 

#   define kPacketSocketPlatformStaticFields()  \
        kPointer dummy;

#endif

typedef struct kPacketSocketPacketClass
{
    kObjectClass base;

    kSize size;
    kByte* buffer;
    kAlloc bufferAlloc;

} kPacketSocketPacketClass;

kDeclareClassEx(kFs, kPacketSocketPacket, kObject) 

typedef struct kPacketSocketClass
{
    kObjectClass base;

    kPacketSocketPlatformFields()
} kPacketSocketClass;

typedef struct kPacketSocketVTable
{
    kObjectVTable base;
} kPacketSocketVTable;

typedef struct kPacketSocketStatic
{
    kPacketSocketPlatformStaticFields() 
} kPacketSocketStatic;

kDeclareFullClassEx(kFs, kPacketSocket, kObject) 

kFsFx(kStatus) xkPacketSocket_InitStatic();
kFsFx(kStatus) xkPacketSocket_ReleaseStatic();

kFsFx(kStatus) kPacketSocketPacket_Construct(kPacketSocketPacket* packet, kAlloc bufferAlloc, kSize size, kAlloc allocator);
kFsFx(kStatus) kPacketSocketPacket_Init(kPacketSocketPacket packet, kAlloc bufferAlloc, kSize size, kType type, kAlloc allocator);
kFsFx(kStatus) kPacketSocketPacket_VRelease(kPacketSocketPacket packet);

kFsFx(void*) kPacketSocketPacket_Buffer(kPacketSocketPacket packet);
kFsFx(kSize) kPacketSocketPacket_BufferSize(kPacketSocketPacket packet);

kFsFx(kStatus) kPacketSocket_Init(kPacketSocket sockt, const kChar* adapterName, k16u* protocols, kSize protocolCount, kType type, kBool promiscuousMode, kAlloc allocator);
kFsFx(kStatus) kPacketSocket_VRelease(kPacketSocket sockt);

#endif
