#ifndef k_LD_CAL_LOOKUP_X_H
#define k_LD_CAL_LOOKUP_X_H

#include <kApi/kApi.h>
#include <kFireSync/Data/kDataTree.h>

#define kLD_CAL_LOOKUP_REVERSE_LOOKUP_COUNT     (1000)  // 0.1% density is sufficient to eliminate iteration for current generation of driver pots. Can be expanded at any time

typedef struct kLdCalLookupClass
{
    kObjectClass base;

    kBool hasLimit;

    k64f calDriverTemperature;

    k64f powerTempDeltaCoeff;
    k64f limitTempDeltaCoeff;

    kSize powerInputBegin;
    kSize limitInputBegin;

    k64f powerOutputBegin;
    k64f powerOutputEnd;

    k64f limitOutputBegin;
    k64f limitOutputEnd;

    kArray2 powerOutputLookup;
    kArray2 limitOutputLookup;

    kArray1 powerOutput;
    kArray1 limitOutput;

    k64f minIntensity;          //Minimum supported intensity setting (%).

} kLdCalLookupClass;

kDeclareClassEx(kFs, kLdCalLookup, kObject)

kFsFx(kStatus) kLdCalLookup_Init(kLdCalLookup lookup, kLdCal cal, kAlloc alloc);
kFsFx(kStatus) kLdCalLookup_VRelease(kLdCalLookup lookup);

kFsFx(k64f) kLdCalLookup_CompensatePower(kLdCalLookup lookup, k64f tempDeltaCoeff, k64f tempIn, k64f tempOut, k64f powerIn);
kFsFx(kStatus) kLdCalLookup_ConstructOutputLookup(kLdCalLookup lookup, kArray1 powerOutput, kArray1 * powerLookup, k64f* lookupBegin, k64f* lookupEnd);
kFsFx(kStatus) kLdCalLookup_LookupByOutput(kLdCalLookup lookup, k64f output, kArray1 calOutputs, kArray2 outputLookup, k64f lookupMin, k64f lookupMax, kSize* index);

kFsFx(kStatus) kLdCalLookup_CalculateMinIntensity(kLdCalLookup lookup, kLdCal cal);

#endif
