/** 
 * @file    kElfPatch.h
 * @brief   This file declares ELF binary patching functions.
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_ELF_PATCH_H
#define K_FIRESYNC_ELF_PATCH_H

#include <kFireSync/kFsDef.h>

/** 
 * Implements FSS-1229 binary patching algorithm. 
 *
 * @public                  @memberof kElfPatch
 * @param   stream          kMemory object.
 * @param   offset          Offset in stream where ELF starts.
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kElfPatch_Apply(kMemory stream, k64s offset, kAlloc allocator);

#endif
