/** 
 * @file    kUpgThread.h
 * @brief   Declares the kUpgThread class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kFS_UPG_THREAD_H
#define kFS_UPG_THREAD_H

#include <kFireSync/kFsDef.h>
#include <kFireSync/Upgrade/kUpgTask.h>

/**
 * Runs a list of asynchronous tasks in order.
 *
 * @class       kUpgThread
 * @extends     kObject
 * @ingroup     kFireSync-Upgrade
 */
typedef kObject kUpgThread;

/** @cond */
kDeclareClassEx(kFs, kUpgThread, kObject)
/** @endcond */

kFsFx(kStatus) kUpgThread_Construct(kUpgThread* thread, kAlloc alloc);

kFsFx(kBool) kUpgThread_Completed(kUpgThread thread);
kFsFx(kStatus) kUpgThread_Status(kUpgThread thread);

kFsFx(kStatus) kUpgThread_AddTask(kUpgThread thread, kUpgTask task);
kFsFx(kStatus) kUpgThread_Advance(kUpgThread thread, kBool* waiting);

kFsFx(k32u) kUpgThread_Progress(kUpgThread thread);
kFsFx(k64u) kUpgThread_Weight(kUpgThread thread);

#endif
