/** 
 * @file    kUpgActionRunner.h
 * @brief   Declares the kUpgActionRunner class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kFS_UPG_ACTION_RUNNER_H
#define kFS_UPG_ACTION_RUNNER_H

#include <kFireSync/kFsDef.h>
#include <kApi/Utils/kEvent.h>
#include <kFireSync/Upgrade/kUpgAction.h>
#include <kFireSync/Client/kSystem.h>
#include <kFireSync/Client/kNode.h>
#include <kFireSync/Data/kArchive.h>

/**
 * Executes sequences of upgrade actions (concurrently when applicable).
 *
 * @class       kUpgActionRunner
 * @extends     kObject
 * @ingroup     kFireSync-Upgrade
 */
typedef kObject kUpgActionRunner;

/** @cond */
kDeclareClassEx(kFs, kUpgActionRunner, kObject)
kDeclareValueEx(kFs, kUpgActionRunnerSensor, kValue)
/** @endcond */

kFsFx(kStatus) kUpgActionRunner_Construct(kUpgActionRunner* runner, kSystem system, kArchive archive, kAlloc alloc);

kFsFx(kStatus) kUpgActionRunner_ClearSensors(kUpgActionRunner runner);
kFsFx(kStatus) kUpgActionRunner_AddSensor(kUpgActionRunner runner, k32u nodeId);
kFsFx(kSize) kUpgActionRunner_SensorCount(kUpgActionRunner runner);

kFsFx(kStatus) kUpgActionRunner_SetLogEvent(kUpgActionRunner runner, kEvent event);

kFsFx(kStatus) kUpgActionRunner_AddAction(kUpgActionRunner runner, kSize index, kUpgAction action);
kFsFx(kStatus) kUpgActionRunner_AddReset(kUpgActionRunner runner, kSize index);
kFsFx(kStatus) kUpgActionRunner_AddActionToAllSensors(kUpgActionRunner runner, kUpgAction action);

kFsFx(kStatus) kUpgActionRunner_Run(kUpgActionRunner runner);
kFsFx(k32u) kUpgActionRunner_Progress(kUpgActionRunner runner); // this is thread safe with Upgrade

#endif
