/** 
 * @file    kUpgAction.h
 * @brief   Declares the kUpgAction class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kFS_UPG_ACTION_H
#define kFS_UPG_ACTION_H

#include <kFireSync/kFsDef.h>
#include <kFireSync/Upgrade/kUpgCondition.h>

/**
 * Represents an upgrade action (e.g. firmware upload).
 *
 * This simply describes the action, rather than executing it.
 *
 * @class       kUpgAction
 * @extends     kObject
 * @ingroup     kFireSync-Upgrade
 */
typedef kObject kUpgAction;

/** @cond */
kDeclareClassEx(kFs, kUpgAction, kObject)
/** @endcond */

typedef enum
{
    kFS_UPG_ACTION_FIRMWARE,
    kFS_UPG_ACTION_DIRECTORY,
    kFS_UPG_ACTION_DIRECTORY_DELETE,
    kFS_UPG_ACTION_FILE,
    kFS_UPG_ACTION_FILE_DELETE,
    kFS_UPG_ACTION_VERSION,
    kFS_UPG_ACTION_DEFINE,
    kFS_UPG_ACTION_REQUIRE,
    kFS_UPG_ACTION_RESCUE_WAIT_SET
} kUpgActionOp;

kFsFx(kStatus) kUpgAction_Construct(kUpgAction* action, kAlloc alloc);

kFsFx(kStatus) kUpgAction_Read(kUpgAction action, kXml xml, kXmlItem item);
kFsFx(kStatus) kUpgAction_Write(kUpgAction action, kXml xml, kXmlItem item);

kFsFx(kStatus) kUpgAction_SetOp(kUpgAction action, kUpgActionOp op);
kFsFx(kUpgActionOp) kUpgAction_Op(kUpgAction action);

kFsFx(kStatus) kUpgAction_SetName(kUpgAction action, const kChar* name);
kFsFx(const kChar*) kUpgAction_Name(kUpgAction action);

kFsFx(kStatus) kUpgAction_SetSource(kUpgAction action, const kChar* source);
kFsFx(const kChar*) kUpgAction_Source(kUpgAction action);

kFsFx(kStatus) kUpgAction_SetValue(kUpgAction action, const kChar* value);
kFsFx(const kChar*) kUpgAction_Value(kUpgAction action);

kFsFx(kStatus) kUpgAction_SetOverwrite(kUpgAction action, kBool overwrite);
kFsFx(kBool) kUpgAction_Overwrite(kUpgAction action);

kFsFx(kStatus) kUpgAction_SetGroup(kUpgAction action, const kChar* group);
kFsFx(const kChar*) kUpgAction_Group(kUpgAction action);

kFsFx(kStatus) kUpgAction_SetDescription(kUpgAction action, const kChar* description);
kFsFx(const kChar*) kUpgAction_Description(kUpgAction action);

kFsFx(kSize) kUpgAction_ConditionCount(kUpgAction action);
kFsFx(kUpgCondition) kUpgAction_ConditionAt(kUpgAction action, kSize index);

#endif
