/** 
 * @file    kSvHealthOutNet.h
 * @brief   Declares the kSvHealthOutNet class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_HEALTH_OUT_NET_H
#define K_FIRESYC_SERVER_HEALTH_OUT_NET_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class   kSvHealthOutNet
 * @extends kSvHealthOutChannel
 * @ingroup kFireSync-Server-Network
 * @brief   Represents the server side of an FHSP-6 connection.
 */
//typedef kSvHealthOutChannel kSvHealthOutNet;      --forward-declared in kFsDef.x.h
 
/** 
 * Constructs a kSvHealthOutNet object.
 *
 * @public                  @memberof kSvHealthOutNet
 * @param   channel         Destination for the constructed object handle. 
 * @param   service         Health output service (parent). 
 * @param   client          Client connection.
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kSvHealthOutNet_Construct(kSvHealthOutNet* channel, kSvHealthOut service, kTcpClient client, kAlloc allocator);

#include <kFireSync/Server/Network/kSvHealthOutNet.x.h>

#endif
