/** 
 * @file    kSvActions.x.h
 *
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_ACTIONS_X_H
#define K_FIRESYC_SERVER_ACTIONS_X_H

#include <kFireSync/Action/kAxAction.h>

#define kSV_ACTIONS_CONFIG_VERSION            (1)               //Action configuration format version.

typedef struct kSvActionsParams
{
    kActionTrigger triggerType; 
    const kChar* invokeTypeName; 
    const kChar* invokeActionName; 
    kXml invokeConfig; 
    kObject invokeInput; 
    kObject invokeOutput; 
} kSvActionsParams; 

typedef struct kSvActionsClass
{
    kObjectClass base; 
    
    kSvNode node;                   //Server node (parent). 

    kLock lock;                     //Mutual exclusion lock. 

    kArrayList assemblies;          //List of assemblies searched for action types. 
    kArrayList actionTypes;         //List of available user-defined action types -- kArrayList<kType>.

    kArrayList actions;             //List of actions -- kArrayList<kAxAction>.

    kCallback actionFx;             //Action handler

} kSvActionsClass; 

kDeclareClassEx(kFs, kSvActions, kObject)
        
kFsFx(kStatus) kSvActions_Init(kSvActions actions, kType type, kSvNode node, kAlloc alloc);
kFsFx(kStatus) kSvActions_VRelease(kSvActions actions);

kFsFx(kStatus) kSvActions_FormatActionTypes(kSvActions actions, kXml xml, kXmlItem item); 
kFsFx(kStatus) kSvActions_FormatActions(kSvActions actions, kXml xml, kXmlItem item, const kChar* itemName, kArrayList blockList); 

kFsFx(kStatus) kSvActions_ParseActions(kSvActions actions, kXml xml, kXmlItem item); 

kFsFx(kStatus) kSvActions_EnumerateActionTypes(kSvActions actions);

kFsFx(kStatus) kSvActions_FindActionType(kSvActions actions, const kChar* typeName, kType* type); 

kFsFx(kStatus) kSvActions_BuildActionList(kSvActions actions, kArrayList* actionList); 
kFsFx(kStatus) kSvActions_ExecuteInvokedAction(kSvActions actions, const kChar* typeName, kXml config, kObject input, kObject* output); 
kFsFx(kStatus) kSvActions_ExecuteInvokedNamedAction(kArrayList actionList, const kChar* name, kObject input, kObject* output); 
kFsFx(kStatus) kSvActions_ExecuteTriggeredActions(kArrayList actionList, kActionTrigger trigger); 

kFsFx(kStatus) kSvActions_DefaultActionHandler(kSvActions actions, kPointer unused, kPointer args); 

//kAxEnviron interface
kFsFx(kNode) kSvActions_Node(kSvActions actions);
kFsFx(kSystem) kSvActions_System(kSvActions actions);

#endif
