/** 
 * @file    kSvTestJig.x.h
 *
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_TEST_JIG_X_H
#define K_FIRESYC_SERVER_TEST_JIG_X_H

typedef struct kSvTestJigClass
{
    kObjectClass base; 
    
    kSvNode node;               //Server node (parent). 
    kHxTestJig hwTestJig;         //Hardware I/O test (kHxTestJig).

} kSvTestJigClass; 

kDeclareClassEx(kFs, kSvTestJig, kObject)
        
kFsFx(kStatus) kSvTestJig_Init(kSvTestJig test, kType type, kSvNode node, kHxTestJig hwTestJig, kAlloc alloc);
kFsFx(kStatus) kSvTestJig_VRelease(kSvTestJig test);

kFsFx(kStatus) kSvTestJig_Format(kSvTestJig test, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvTestJig_Parse(kSvTestJig test, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvTestJig_Command(kSvTestJig test, kTestJigCommand command, k64u data);
kFsFx(kStatus) kSvTestJig_Stats(kSvTestJig test, kTestJigStats* stats);

#endif
