/** 
 * @file    kSvTestJig.h
 * @brief   Declares the kSvTestJig class and related types. 
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_TEST_JIG_H
#define K_FIRESYC_SERVER_TEST_JIG_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class       kSvTestJig
 * @extends     kObject
 * @ingroup     kFireSync-Server-Devices
 * @brief       Lightweight server wrapper for kHxTestJig. 
 */
//typedef kObject kSvTestJig;          --forward-declared in kFsDef.x.h

/** 
 * Constructs a kSvTestJig object.
 *
 * @public              @memberof kSvTestJig
 * @param   serial      Destination for the constructed object handle. 
 * @param   node        Server node (parent). 
 * @param   hwTestJig   I/O test hardware driver handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvTestJig_Construct(kSvTestJig* serial, kSvNode node, kHxTestJig hwTestJig, kAlloc allocator);

#include <kFireSync/Server/Devices/kSvTestJig.x.h>

#endif
