/** 
 * @file    kSvProjector.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_PROJECTOR_X_H
#define K_FIRESYC_SERVER_PROJECTOR_X_H

/**
 * @internal
 * @struct      kSvProjectorState
 * @extends     kValue
 * @ingroup     kFireSync-Server-Devices
 * @brief       Used to retain projector state settings that aren't stored in kHxProjector.
 */
typedef struct kSvProjectorState
{
    kBool autoGapEnabled;           //Is automatic gap calculation enabled?
} kSvProjectorState; 

kDeclareValueEx(kFs, kSvProjectorState, kValue)

typedef struct kSvProjectorClass
{
    kObjectClass base; 
    
    kSvNode node;                   //Server node (parent). 
    kHxProjector hwProjector;       //Hardware projector (kHxProjector).

    kArrayList states;              //State settings not retained by kHardware.

} kSvProjectorClass; 

kDeclareClassEx(kFs, kSvProjector, kObject)
        
kFsFx(kStatus) kSvProjector_Init(kSvProjector projector, kType type, kSvNode node, kHxProjector hwProjector, kAlloc alloc);
kFsFx(kStatus) kSvProjector_VRelease(kSvProjector projector);

kFsFx(kStatus) kSvProjector_FormatStates(kSvProjector projector, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvProjector_FormatExtensions(kSvProjector projector, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvProjector_ParseStates(kSvProjector projector, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvProjector_ParseExtensions(kSvProjector projector, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvProjector_SetStateCount(kSvProjector projector, kSize count);

#endif
