/** 
 * @file    kSvIoTest.x.h
 *
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_IO_TEST_X_H
#define K_FIRESYC_SERVER_IO_TEST_X_H

typedef struct kSvIoTestClass
{
    kObjectClass base; 
    
    kSvNode node;               //Server node (parent). 
    kHxIoTest hwIoTest;         //Hardware I/O test (kHxIoTest).

} kSvIoTestClass; 

kDeclareClassEx(kFs, kSvIoTest, kObject)
        
kFsFx(kStatus) kSvIoTest_Init(kSvIoTest test, kType type, kSvNode node, kHxIoTest hwIoTest, kAlloc alloc);
kFsFx(kStatus) kSvIoTest_VRelease(kSvIoTest test);

kFsFx(kStatus) kSvIoTest_FormatDevice(kSvIoTest test, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvIoTest_ParseDevice(kSvIoTest test, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvIoTest_Apply(kSvIoTest test);

kFsFx(kStatus) kSvIoTest_Reset(kSvIoTest test);
kFsFx(kStatus) kSvIoTest_Stats(kSvIoTest test, kIoTestStats* stats);
kFsFx(kStatus) kSvIoTest_ReadSerial(kSvIoTest test, void* buffer, kSize capacity, kSize* bytesRead);

#endif
