/** 
 * @file    kSvEventManager.h
 * @brief   Declares the kSvEventManager class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_EVENT_MANAGER_H
#define K_FIRESYC_SERVER_EVENT_MANAGER_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class       kSvEventManager
 * @extends     kObject
 * @ingroup     kFireSync-Server-Devices
 * @brief       Lightweight server wrapper for kHxEvent. 
 */
//typedef kObject kSvEventManager;          --forward-declared in kFsDef.x.h

/** 
 * Constructs a kSvEventManager object.
 *
 * @public                  @memberof kSvEventManager
 * @param   manager         Destination for the constructed object handle. 
 * @param   node            Server node (parent). 
 * @param   hwEvent         Event manager hardware driver handle. 
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kSvEventManager_Construct(kSvEventManager* manager, kSvNode node, kHxEvent hwEvent, kAlloc allocator);

kFsFx(kStatus) kSvEventManager_Format(kSvEventManager manager, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvEventManager_Parse(kSvEventManager manager, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvEventManager_Schedule(kSvEventManager manager, k64s target);
kFsFx(kStatus) kSvEventManager_Trigger(kSvEventManager manager);

kFsFx(kStatus) kSvEventManager_GetStats(kSvEventManager manager, kEventStats* stats);

kFsFx(kStatus) kSvEventManager_PrepareForPrime(kSvEventManager manager, k64u period, k32u primeCount);
kFsFx(kStatus) kSvEventManager_RestoreAfterPrime(kSvEventManager manager);

#include <kFireSync/Server/Devices/kSvEventManager.x.h>

#endif

