/** 
 * @file    kSvDigitalOut.h
 * @brief   Declares the kSvDigitalOut class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DIGITAL_OUT_H
#define K_FIRESYC_SERVER_DIGITAL_OUT_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class       kSvDigitalOut
 * @extends     kObject
 * @ingroup     kFireSync-Server-Devices
 * @brief       Lightweight server wrapper for kHxDigitalOut. 
 */
//typedef kObject kSvDigitalOut;          --forward-declared in kFsDef.x.h

/** 
 * Constructs a kSvDigitalOut object.
 *
 * @public              @memberof kSvDigitalOut
 * @param   digital     Destination for the constructed object handle. 
 * @param   node        Server node (parent). 
 * @param   hwDigital   Digital hardware driver handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvDigitalOut_Construct(kSvDigitalOut* digital, kSvNode node, kHxDigitalOut hwDigital, kAlloc allocator);

kFsFx(kStatus) kSvDigitalOut_Format(kSvDigitalOut digital, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvDigitalOut_Parse(kSvDigitalOut digital, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvDigitalOut_SetState(kSvDigitalOut digital, kBool state);
kFsFx(kStatus) kSvDigitalOut_Stats(kSvDigitalOut digital, kDigitalOutStats* stats);

kFsFx(kStatus) kSvDigitalOut_Trigger(kSvDigitalOut digital);

#include <kFireSync/Server/Devices/kSvDigitalOut.x.h>

#endif
