/** 
 * @file    kPxIoBlock.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PX_IO_BLOCK_X_H
#define K_FIRESYNC_PX_IO_BLOCK_X_H

#include <kFireSync/Pipe/kPxBlock.h>

typedef struct kPxIoBlockClass
{
    kPxBlockClass base; 
    kCallback receiveFx; 
} kPxIoBlockClass; 

kDeclareClassEx(kFs, kPxIoBlock, kPxBlock)
        
kFsFx(const kChar*) kPxIoBlock_VDescription();

kFsFx(kStatus) kPxIoBlock_VInit(kPxIoBlock block, kType type, const kChar* name, k32u nodeId, k32u blockId, kPxEnviron pipeEnviron, kAlloc alloc); 
kFsFx(kStatus) kPxIoBlock_VRelease(kPxIoBlock block); 

kFsFx(kStatus) kPxIoBlock_VOnReceive(kPxIoBlock block, kPxPort port, kMsgSet msgSet);

#endif
