/** 
 * @file    kProfileProbe.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PROFILE_PROBE_X_H
#define K_FIRESYNC_PROFILE_PROBE_X_H

#include <kApi/Threads/kTimer.h>

/* 
 * kProfileProbe
 */

typedef struct kProfileProbeClass
{
    kObjectClass base; 

    kHealth provider;       //Health provider (or kNULL if no provider).
    kObject lock;           //Protects mutable state. 

    kText64 name;           //Descriptive label (e.g. "Camera0/ExposureCount").

    k64u start;             //Time at start (us).
    k64u count;             //Invocation count. 
    k64u sum;               //Sum of execution times (us).
    k32u value;             //Most recent execution time (us). 
    k32u min;               //Minimum execution time (us). 
    k32u max;               //Maximum execution time (us).
            
} kProfileProbeClass; 

typedef struct kProfileProbeVTable
{
    kObjectVTable base; 
    kStatus (kCall* VInitDefault)(kProfileProbe probe, kType type, kHealthProbe provider, const kChar* name, kAlloc alloc); 
    void (kCall* VStart)(kProfileProbe probe);
    void (kCall* VStop)(kProfileProbe probe);
    void (kCall* VStartEx)(kProfileProbe probe, kProfileContext* context);
    void (kCall* VStopEx)(kProfileProbe probe, kProfileContext* context);
    void (kCall* VStats)(kProfileProbe probe, kProfileStat* stat);
} kProfileProbeVTable; 

kDeclareVirtualClassEx(kFs, kProfileProbe, kObject)

kFsFx(kStatus) xkProfileProbe_ConstructImpl(kProfileProbe* probe, kHealth provider, const kChar* name, kAlloc allocator);

kFsFx(kStatus) kProfileProbe_Init(kProfileProbe probe, kType type, kHealth provider, const kChar* name, kAlloc alloc);
kFsFx(kStatus) kProfileProbe_VRelease(kProfileProbe probe);

kFsFx(kStatus) kProfileProbe_VInitDefault(kProfileProbe probe, kType type, kHealth provider, const kChar* name, kAlloc alloc);

kFsFx(void) kProfileProbe_VStart(kProfileProbe probe);
kFsFx(void) kProfileProbe_VStop(kProfileProbe probe);

kFsFx(void) kProfileProbe_VStartEx(kProfileProbe probe, kProfileContext* context);
kFsFx(void) kProfileProbe_VStopEx(kProfileProbe probe, kProfileContext* context);

kFsFx(void) kProfileProbe_AddSample(kProfileProbe probe, k32u elapsed); 

kInlineFx(void) kProfileProbe_Stats(kProfileProbe probe, kProfileStat* stat)
{
    xkProfileProbe_VTable(probe)->VStats(probe, stat); 
}

kFsFx(void) kProfileProbe_VStats(kProfileProbe probe, kProfileStat* stat);

#endif
