/** 
* @file    kHealthSummary.x.h
*
* @internal
* Copyright (C) 2019-2022 by LMI Technologies Inc. All rights reserved.
*/
#ifndef K_FIRESYNC_HEALTH_SUMMARY_X_H
#define K_FIRESYNC_HEALTH_SUMMARY_X_H

/*
 * kHealthSummaryStat
*/

typedef struct kHealthSummaryStatClass
{
    kObjectClass base; 
    kHealthId id;           //health id (id-instance pairs are unique)
    k32u instance;          //health instance value (id-instance pairs are unique)
    kText64 name;           //unique health stat name
    kArrayList data;        //health log entries -- kArrayList<k64s>
} kHealthSummaryStatClass;

kDeclareClassEx(kFs, kHealthSummaryStat, kObject)

kFsFx(kStatus) kHealthSummaryStat_Construct(kHealthSummaryStat* stat, const kChar* name, kHealthId id, k32u instance, kSize initialCapacity, kAlloc allocator);
kFsFx(kStatus) xkHealthSummaryStat_Init(kHealthSummaryStat stat, kType type, const kChar* name, kHealthId id, k32u instance, kSize initialCapacity, kAlloc alloc);

kFsFx(kStatus) xkHealthSummaryStat_ConstructFramework(kHealthSummaryStat* stat, kAlloc allocator); 
kFsFx(kStatus) xkHealthSummaryStat_InitFramework(kHealthSummaryStat stat, kType type, kAlloc alloc);

kFsFx(kStatus) xkHealthSummaryStat_VRelease(kHealthSummaryStat stat);

kFsFx(kStatus) xkHealthSummaryStat_VClone(kHealthSummaryStat stat, kHealthSummaryStat source, kAlloc valueAlloc, kObject context); 
kFsFx(kSize) xkHealthSummaryStat_VSize(kHealthSummaryStat stat); 

kFsFx(kStatus) xkHealthSummaryStat_WriteDat6V0(kHealthSummaryStat stat, kSerializer serializer); 
kFsFx(kStatus) xkHealthSummaryStat_ReadDat6V0(kHealthSummaryStat stat, kSerializer serializer); 

kInlineFx(const kChar*) kHealthSummaryStat_Name(kHealthSummaryStat stat)
{
    kObj(kHealthSummaryStat, stat);

    return obj->name;
}

kInlineFx(kHealthId) kHealthSummaryStat_Id(kHealthSummaryStat stat)
{
    kObj(kHealthSummaryStat, stat);

    return obj->id;
}

kInlineFx(k32u) kHealthSummaryStat_Instance(kHealthSummaryStat stat)
{
    kObj(kHealthSummaryStat, stat);

    return obj->instance;
}

kInlineFx(kArrayList) kHealthSummaryStat_Data(kHealthSummaryStat stat)
{
    kObj(kHealthSummaryStat, stat);

    return obj->data;
}

/*
 * kHealthSummary
*/

typedef struct kHealthSummaryClass
{
    kObjectClass base;
    kSize entryCount;       //count of log entries stat
    kArrayList stats;       //list of summary stats, sorted by text name -- kArrayList<kHealthSummaryStat>
    kMap statLookup;        //lookup from id-instance pair to stat; constructed when used, otherwise kNULL --kMap<k64u, kHealthSummaryStat>      
} kHealthSummaryClass;

kDeclareClassEx(kFs, kHealthSummary, kObject)

kFsFx(kStatus) xkHealthSummary_ConstructFramework(kHealthSummary* summary, kAlloc allocator);
kFsFx(kStatus) xkHealthSummary_InitFramework(kHealthSummary summary, kType type, kAlloc alloc);

kFsFx(kStatus) xkHealthSummary_Init(kHealthSummary summary, kType type, kAlloc alloc);
kFsFx(kStatus) xkHealthSummary_VRelease(kHealthSummary summary);

kFsFx(kStatus) xkHealthSummary_VClone(kHealthSummary summary, kHealthSummary source, kAlloc valueAlloc, kObject context); 
kFsFx(kSize) xkHealthSummary_VSize(kHealthSummary summary); 

kFsFx(kStatus) xkHealthSummary_WriteDat6V0(kHealthSummary summary, kSerializer serializer); 
kFsFx(kStatus) xkHealthSummary_ReadDat6V0(kHealthSummary summary, kSerializer serializer); 

kFsFx(kStatus) xkHealthSummary_BuildLookup(kHealthSummary summary);
kFsFx(kStatus) xkHealthSummary_Clear(kHealthSummary summary);

kInlineFx(k64u) xkHealthSummary_MakeKey(kHealthId id, k32u instance)
{
    return ((k64u)instance << 32) | (k64u) id;
}

#endif
