/** 
 * @file    kHxIoTest.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_IO_TEST_X_H
#define K_FIRESYNC_HX_IO_TEST_X_H

#define kHX_IO_TEST_DIGITAL_OUTPUT_COUNT        (2)
#define kHX_IO_TEST_DEFAULT_AD_AVERAGE_WINDOW   (4)

#define kHX_IO_TEST_DEFAULT_BIT_RATE            (115200)

typedef struct kHxIoTestVTable
{
    kObjectVTable base; 

    kStatus (kCall* VApply)(kHxIoTest test);
    kStatus (kCall* VStats)(kHxIoTest test, kIoTestStats* stats);
    kStatus (kCall* VClearStats)(kHxIoTest test);
    kStatus (kCall* VReadSerial)(kHxIoTest test, void* buffer, kSize capacity, kSize* bytesRead);
    kStatus (kCall* VReset)(kHxIoTest test);
    kStatus (kCall* VClear)(kHxIoTest test);

} kHxIoTestVTable;

typedef struct kHxIoTestClass
{
    kObjectClass base;  

    /* 
     * Read-only attributes established during init.
     */

    kHxNode node;                                               //Parent.
    kSize index;                                                //Index of this event object within node list.

    /* 
     * Read-only attributes that must be established by descendant during descendant init.
     */

    kIoTestModel model;                                         //I/O test model.

    /* 
     * Dynamic properties that can be re/initialized by calling Clear method from descendant. 
     */

    kBool g20x0MasterMode;
    kIoTestSerialMode serialMode;
    k32u bitRate;
    kBool safety;
    kBool digitalOutput[kHX_IO_TEST_DIGITAL_OUTPUT_COUNT];
    k32u syncIo;
    kSize movingAvgWindow;
} kHxIoTestClass;

kDeclareVirtualClassEx(kFs, kHxIoTest, kObject)

/*
* Protected 
*/

kFsFx(kStatus) xkHxIoTest_Init(kHxIoTest test, kType type, kHxNode node, kSize index, kAlloc alloc); 

kFsFx(kStatus) xkHxIoTest_VRelease(kHxIoTest test); 

kInlineFx(kStatus) xkHxIoTest_VApply(kHxIoTest test)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxIoTest_VStats(kHxIoTest test, kIoTestStats* stats)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxIoTest_VClearStats(kHxIoTest test)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxIoTest_VReadSerial(kHxIoTest test, void* buffer, kSize capacity, kSize* bytesRead)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxIoTest_VReset(kHxIoTest test)
{
    return kERROR_UNIMPLEMENTED;
}

//can optionally be overridden, but probably doesn't need to be
kFsFx(kStatus) xkHxIoTest_VClear(kHxIoTest test);

#endif
