/** 
 * @file    kTerrainModel.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_TERRAIN_MODEL_X_H
#define K_FIRESYNC_TERRAIN_MODEL_X_H

typedef struct kTerrainModelClass 
{
    kObjectClass base;
    kArrayList regions;
    kBool suppressionEnabled;
    k32s suppressedValue;
} kTerrainModelClass;

kDeclareClassEx(kFs, kTerrainModel, kObject)

kFsFx(kStatus) kTerrainModel_Init(kTerrainModel model, kType classType, k32u minimumRegions, kAlloc allocator);

kFsFx(kStatus) xkTerrainModel_ConstructFramework(kTerrainModel* model, kAlloc allocator); 
kFsFx(kStatus) xkTerrainModel_InitFramework(kTerrainModel model, kType classType, kAlloc allocator);

kFsFx(kStatus) kTerrainModel_VRelease(kTerrainModel model); 
kFsFx(kStatus) kTerrainModel_VDisposeItems(kTerrainModel model);
kFsFx(kBool) kTerrainModel_VHasShared(kTerrainModel model);
kFsFx(kSize) kTerrainModel_VSize(kTerrainModel model);
kFsFx(kAllocTrait)  kTerrainModel_VAllocTraits(kTerrainModel model);
kFsFx(kStatus) kTerrainModel_VClone(kTerrainModel model, kTerrainModel source, kAlloc valueAlloc, kObject context);
kFsFx(kStatus) xkTerrainModel_WriteDat6V0(kTerrainModel model, kSerializer serializer);
kFsFx(kStatus) xkTerrainModel_ReadDat6V0(kTerrainModel model, kSerializer serializer);

#endif
