/**
* @file kSpline.x.h
*
* @internal
* Copyright (C) 2007-2022 by LMI Technologies Inc.  All rights reserved.
*/

#ifndef K_FIRESYNC_SPLINE_X_H
#define K_FIRESYNC_SPLINE_X_H

typedef struct kSplineClass
{
    kObjectClass base;

    kArray2 coefficients;           //spline coefficients; one row per polynomial; in given row, lowest-order coefficient first -- kArray2<k64f>
    kArray1 knots;                  //spline knots (x-values) -- kArray1<k64f> 
    k64f domain[2];                 //minimum and maximum domain (x) values

} kSplineClass;

kDeclareClassEx(kFs, kSpline, kObject)

kStatus kSpline_Init(kSpline spline, kSize knotCount, kAlloc allocator);

kFsFx(kStatus) kSpline_VRelease(kSpline spline);

#endif 
