/** 
 * @file    kHealthMsg.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_HEALTH_MSG_X_H
#define K_FIRESYNC_HEALTH_MSG_X_H

typedef struct kHealthMsgClass
{
    kObjectClass base; 
    k32u source; 
    kObject content; 
} kHealthMsgClass; 

kDeclareClassEx(kFs, kHealthMsg, kObject)
        
kFsFx(kStatus) xkHealthMsg_ConstructFramework(kHealthMsg* msg, kAlloc allocator); 

kFsFx(kStatus) kHealthMsg_Init(kHealthMsg msg, kType type, k32u source, kObject content, kAlloc alloc); 

kFsFx(kStatus) kHealthMsg_VClone(kHealthMsg msg, kHealthMsg source, kAlloc valueAlloc, kObject context); 

kFsFx(kStatus) kHealthMsg_VRelease(kHealthMsg msg); 
kFsFx(kStatus) kHealthMsg_VDisposeItems(kHealthMsg msg); 

kFsFx(kBool) kHealthMsg_VHasShared(kHealthMsg msg); 
kFsFx(kSize) kHealthMsg_VSize(kHealthMsg msg); 

kFsFx(kStatus) xkHealthMsg_WriteDat6V0(kHealthMsg msg, kSerializer serializer); 
kFsFx(kStatus) xkHealthMsg_ReadDat6V0(kHealthMsg msg, kSerializer serializer); 

#endif
