/** 
 * @file    kHealthMsg.h
 * @brief   Declares the kHealthMsg type. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_HEALTH_MSG_H
#define K_FIRESYNC_HEALTH_MSG_H

#include <kFireSync/kNodeDef.h>

/** @relates kHealthMsg @{ */
#define kHEALTH_MSG_SOURCE_HOST     (0)             ///< Recommended node identifier to use for health messages that originate from local (non-node) host. 
/** @} */

/**
 * @class   kHealthMsg
 * @extends kObject
 * @ingroup kFireSync-Data
 * @brief   Represents a health channel message sent by a node. 
 */
//typedef kObject kHealthMsg;        --forward-declared in kFsDef.x.h

/** 
 * Constructs a kHealthMsg object. 
 *
 * @public              @memberof kHealthMsg
 * @param   msg         Receives the constructed kHealthMsg object. 
 * @param   source      Source node identifier. 
 * @param   content     Health content item. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
 kFsFx(kStatus) kHealthMsg_Construct(kHealthMsg* msg, k32u source, kObject content, kAlloc allocator); 

/** 
 * Gets the message source. 
 *
 * @public          @memberof kHealthMsg
 * @param   msg     kHealthMsg object. 
 * @return          Message source. 
 */
kFsFx(k32u) kHealthMsg_Source(kHealthMsg msg);

/** 
 * Gets the message content.  
 * 
 * @public          @memberof kHealthMsg
 * @param   msg     kHealthMsg object. 
 * @return          Message object. 
 */
kFsFx(kObject) kHealthMsg_Content(kHealthMsg msg);
                                           

#include <kFireSync/Data/kHealthMsg.x.h>

#endif
