/** 
 * @file    kRoute.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_ROUTE_X_H
#define K_FIRESYNC_ROUTE_X_H

typedef struct kRouteClass
{
    kObjectClass base; 

    kNode node;                 //Node (hierarchy ancestor). 
    kPipe pipe;                 //Parent pipe. 
    
    kRouteEntry entry;          //Route data. 
} kRouteClass; 

kDeclareClassEx(kFs, kRoute, kObject)
        
kFsFx(kStatus) kRoute_Construct(kRoute* route, kNode node, kPipe pipe, kAlloc allocator); 

kFsFx(kStatus) kRoute_Init(kRoute route, kType type, kNode node, kPipe pipe, kAlloc alloc); 
kFsFx(kStatus) kRoute_VRelease(kRoute route); 

kFsFx(kSize) kRoute_VHashCode(kRoute route);
kFsFx(kBool) kRoute_VEquals(kRoute route, kRoute other);

kFsFx(kStatus) kRoute_Parse(kRoute route, kXml xml, kXmlItem item); 
kFsFx(kStatus) kRoute_Format(kRoute route, kXml xml, kXmlItem item); 

kFsFx(kStatus) kRoute_VerificationLabel(kRoute route, kChar* label, kSize capacity); 
kFsFx(kStatus) kRoute_Verify(kRoute route); 

kFsFx(kStatus) kRoute_CheckUniqueness(kRoute route, kInfo* info); 
kFsFx(kStatus) kRoute_CheckExistence(kRoute route, kRoutePoint point, kPortDirection direction, kInfo* info); 

#endif
