/** 
 * @file    kOrientation.x.h
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_ORIENTATION_X_H
#define K_FIRESYNC_ORIENTATION_X_H

#define kORIENTATION_MIN_MOTION_THRESHOLD                   (kORIENTATION_MOTION_THRESHOLD_GRANULARITY)     //Minimum threshold (ug). 
#define kORIENTATION_MAX_MOTION_THRESHOLD                   (kORIENTATION_MOTION_THRESHOLD_GRANULARITY*255) //Maximum threshold (ug). 

#define kORIENTATION_MIN_MOTION_DELAY                       (kORIENTATION_MOTION_DELAY_GRANULARITY)         //Minimum delay (us). 
#define kORIENTATION_MAX_MOTION_DELAY                       (kORIENTATION_MOTION_DELAY_GRANULARITY*16)      //Maximum delay (us). 

typedef struct kOrientationClass
{
    kObjectClass base; 
    kNode node; 
    kOrientationModel model;

    kBool enabled;                  //Is orientation device enabled?
    
    kOrientationAxis xRemappedAxis;
    kOrientationAxis yRemappedAxis;
    kOrientationAxis zRemappedAxis;

    kBool xAxisSign;
    kBool yAxisSign;
    kBool zAxisSign;

    k64u anyMotionThreshold;
    k64u noMotionThreshold;
    k64u noMotionDelay;    
} kOrientationClass; 

kDeclareClassEx(kFs, kOrientation, kObject)
        
kFsFx(kStatus) kOrientation_Construct(kOrientation* orientation, kNode node, kSize index, kAlloc allocator); 

kFsFx(kStatus) kOrientation_Init(kOrientation orientation, kType type, kNode node, kAlloc alloc); 
kFsFx(kStatus) kOrientation_VRelease(kOrientation orientation); 

kFsFx(kStatus) kOrientation_ParseDevice(kOrientation orientation, kXml xml, kXmlItem item); 
kFsFx(kStatus) kOrientation_FormatDevice(kOrientation orientation, kXml xml, kXmlItem item); 

kFsFx(kStatus) kOrientation_VerificationLabel(kOrientation orientation, kChar* label, kSize capacity); 
kFsFx(kStatus) kOrientation_Verify(kOrientation orientation); 

kFsFx(kStatus) kOrientation_ClearEx(kOrientation orientation, kNodeClearOption options);

#endif
