/** 
 * @file    kLight.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LIGHT_X_H
#define K_FIRESYNC_LIGHT_X_H

#define kLIGHT_DEFAULT_ENABLE_POWER_SAVER       (kFALSE)        //Default power saver state.

#define kLIGHT_MAX_MAX_DUTY_CYCLE               (100)           //The maximum supported value for maximum duty cycle (percentage) 
#define kLIGHT_MIN_MAX_DUTY_CYCLE               (0.1)           //The minimum supported value for maximum duty cycle (percentage); 
                                                                //Helps steer clear of divide by zero.

typedef struct kLightClass
{
    kObjectClass base; 

    kNode node;
    kPipe pipe;
    kBlock block;

    kLightCapability capabilities;      //Light capability/feature bitset.
    kLdModel modelInfo;                 //Light model information.

    kSize index; 

    kBool enabled;  
    kLightControl control;    
    k32u controlId; 
    kLightPrimingMode primingMode;      //Light priming mode.
    kLightCouplingMode couplingMode;    //Light coupling mode.

    k64f intensity;                     //Light intensity (normalized) 
    k64f minIntensity;                  //Minimum supported light intensity (normalized).

    kLightMask mask;                    //Light mask source type.    
    k32u maskId;                        //Light mask source id. 
    kBool maskPolarity;                 //Light mask polarity. 

    k64f maxDutyCycle;                  //Maximum light duty cycle (percentage).

    kBool powerSaverEnabled;
  
    kArrayList states;                    //kArrayList<kLightState>
    kArrayList extensions;                //kArrayList<kLightExt>

} kLightClass; 

kDeclareClassEx(kFs, kLight, kObject)
        
kFsFx(kStatus) kLight_Construct(kLight* light, kNode node, kSize index, kAlloc allocator); 

kFsFx(kStatus) kLight_Init(kLight light, kType type, kNode node, kSize index, kAlloc alloc); 
kFsFx(kStatus) kLight_VRelease(kLight light); 

kFsFx(kStatus) kLight_Parse(kLight light, kXml xml, kXmlItem item); 
kFsFx(kStatus) kLight_ParseDevice(kLight light, kXml xml, kXmlItem item);
kFsFx(kStatus) kLight_ParseStates(kLight light, kXml xml, kXmlItem item); 
kFsFx(kStatus) kLight_ParseExtensions(kLight light, kXml xml, kXmlItem item); 

kFsFx(kStatus) kLight_Format(kLight light, kXml xml, kXmlItem item); 
kFsFx(kStatus) kLight_FormatVirtual(kLight light, kXml xml, kXmlItem item);
kFsFx(kStatus) kLight_FormatDevice(kLight light, kXml xml, kXmlItem item);
kFsFx(kStatus) kLight_FormatStates(kLight light, kXml xml, kXmlItem item); 
kFsFx(kStatus) kLight_FormatExtensions(kLight light, kXml xml, kXmlItem item); 

kFsFx(kStatus) kLight_ClearEx(kLight light, kNodeClearOption options, kSize stateCount);

kFsFx(kStatus) kLight_VerificationLabel(kLight light, kChar* label, kSize capacity); 
kFsFx(kStatus) kLight_Verify(kLight light); 

kFsFx(kStatus) kLight_RegisterBlock(kLight light);
kFsFx(kStatus) kLight_UnregisterBlock(kLight light);
kFsFx(kStatus) kLight_UpdateBlock(kLight light);

kFsFx(kStatus) kLight_FindSequenceExtension(kLight light, kLightExt* extension); 

kFsFx(k64u) kLight_MinimumEventPeriod(kLight light, kSize eventId); 
kFsFx(k64f) kLight_MaximumCameraDutyCycle(kLight light, kSize cameraId); 

kFsFx(kNode) kLight_Node(kLight light); 

kFsFx(kLdModel) xkLight_ModelInfo(kLight light); 

#endif
