/** 
 * @file    kIoTest.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_IO_TEST_X_H
#define K_FIRESYNC_IO_TEST_X_H

#define kIO_TEST_MAX_SYNC_IO                    (0x0F)
#define kIO_TEST_DEFAULT_MOVING_AVERAGE_WINDOW  (4)
#define kIO_TEST_MIN_MOVING_AVERAGE_WINDOW      (1)
#define kIO_TEST_MAX_MOVING_AVERAGE_WINDOW      (1024)

#define kIO_TEST_DEFAULT_BIT_RATE               (115200)

typedef struct kIoTestClass
{
    kObjectClass base; 
    kNode node; 
    kSize index;
    
    kIoTestSerialMode serialMode;
    k32u bitRate;
    kBool g20x0MasterMode;
    kBool safety;
    kBool digitalOutput[kIO_TEST_DIGITAL_OUTPUT_COUNT];
    k32u syncIo;
    kSize movingAvgWindow;

} kIoTestClass; 

kDeclareClassEx(kFs, kIoTest, kObject)
        
kFsFx(kStatus) kIoTest_Construct(kIoTest* test, kNode node, kSize index, kAlloc allocator); 

kFsFx(kStatus) kIoTest_Init(kIoTest test, kType type, kNode node, kSize index, kAlloc alloc); 
kFsFx(kStatus) kIoTest_VRelease(kIoTest test); 

kFsFx(kStatus) kIoTest_ParseDevice(kIoTest test, kXml xml, kXmlItem item); 
kFsFx(kStatus) kIoTest_FormatDevice(kIoTest test, kXml xml, kXmlItem item); 

kFsFx(kStatus) kIoTest_ClearEx(kIoTest test, kNodeClearOption options);

kFsFx(kStatus) kIoTest_VerificationLabel(kIoTest test, kChar* label, kSize capacity); 
kFsFx(kStatus) kIoTest_Verify(kIoTest test); 

#endif
