/** 
 * @file    kGpioBank.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_GPIO_BANK_X_H
#define K_FIRESYNC_GPIO_BANK_X_H

typedef struct kGpioBankPin
{
    kGpioPin pinType;
    kBool eventsEnabled;
} kGpioBankPin;

kDeclareValueEx(kFs, kGpioBankPin, kValue)

typedef struct kGpioBankClass
{
    kObjectClass base; 
    kArrayList pins;
    kNode node; 
    kSize index; 
    kGpioBankType type;
} kGpioBankClass; 

kDeclareClassEx(kFs, kGpioBank, kObject)

kFsFx(kStatus) kGpioBank_Construct(kGpioBank* bank, kNode node, kSize index, kAlloc allocator); 

kFsFx(kStatus) kGpioBank_Init(kGpioBank bank, kType type, kNode node, kSize index, kAlloc alloc); 
kFsFx(kStatus) kGpioBank_VRelease(kGpioBank bank); 

kFsFx(kStatus) kGpioBank_FormatVirtual(kGpioBank bank, kXml xml, kXmlItem item);

kFsFx(kStatus) kGpioBank_Format(kGpioBank bank, kXml xml, kXmlItem item);
kFsFx(kStatus) kGpioBank_Parse(kGpioBank bank, kXml xml, kXmlItem item);

kFsFx(kStatus) kGpioBank_ClearEx(kGpioBank bank, kNodeClearOption options);  

#endif
