/** 
 * @file    kBlock.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_BLOCK_X_H
#define K_FIRESYNC_BLOCK_X_H

#define kBLOCK_CONFIG_VERSION              (1)              //Block config format version

typedef struct kBlockClass
{
    kObjectClass base; 

    kNode node;                     //Node (hierarchy ancestor).
    kPipe pipe;                     //Pipe to which block belongs. 

    kBool isReadOnly;               //Can this block be modified?

    k32u id;                        //Unique instance identifier. 
    kText32 name;                   //Descriptive instance name. 
    kText32 typeName;               //Remote block type name. 
    kText256 description;           //Description of block type.
    kBool isGrouped;                //Is the block assigned to a processing group?
    k32u groupId;                   //Processing group identifier. 

    kXml settings;                  //Custom settings. 

    kArrayList ports;               //Ports owned by this block. 
   
} kBlockClass; 

kDeclareClassEx(kFs, kBlock, kObject)
        
kFsFx(kStatus) kBlock_Construct(kBlock* block, kNode node, kPipe pipe, kAlloc allocator); 

kFsFx(kStatus) kBlock_Init(kBlock block, kType type, kNode node, kPipe pipe, kAlloc alloc); 
kFsFx(kStatus) kBlock_VRelease(kBlock block); 

kFsFx(kStatus) kBlock_EnableGroup(kBlock block, kBool enabled);
kFsFx(kStatus) kBlock_IsGroupedInfo(kBlock block, kInfoBool* info);

kFsFx(kStatus) kBlock_SetGroupId(kBlock block, k32u groupId);
kFsFx(kStatus) kBlock_GroupIdInfo(kBlock block, kInfo32u* info);

kFsFx(kStatus) kBlock_Parse(kBlock block, kXml xml, kXmlItem item); 
kFsFx(kStatus) kBlock_ParsePorts(kBlock block, kXml xml, kXmlItem item); 

kFsFx(kStatus) kBlock_Format(kBlock block, kXml xml, kXmlItem item); 
kFsFx(kStatus) kBlock_FormatPorts(kBlock block, kXml xml, kXmlItem item); 

kFsFx(kStatus) kBlock_VerificationLabel(kBlock block, kChar* label, kSize capacity); 
kFsFx(kStatus) kBlock_Verify(kBlock block); 

kFsFx(kStatus) kBlock_Validate(kBlock block); 

kFsFx(kStatus) kBlock_SetPipe(kBlock block, kPipe pipe);
kFsFx(kStatus) kBlock_SetReadOnly(kBlock block, kBool isReadOnly); 
kFsFx(kStatus) kBlock_SetTypeName(kBlock block, const kChar* typeName);

kFsFx(kStatus) kBlock_ClearPorts(kBlock block);
kFsFx(kStatus) kBlock_AddPort(kBlock block, kPortDirection direction, const kChar* name, k32u id, kPort* port);

#endif

