/** 
 * @file    kProjectorInfo.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PROJECTOR_INFO_X_H
#define K_FIRESYNC_PROJECTOR_INFO_X_H

typedef struct kProjectorInfoClass
{
    kObjectClass base; 
    kProjectorModel model;           
    k64f pixelClockFrequency;

    kSize width;
    kSize height;

    k64u minExposure;
    k32u minPatternCount;
    k32u maxPatternCount;
    k32u minBitDepth;
    k32u maxBitDepth;
    k32u minIntensity;
    k32u maxIntensity;
    k32u minPaletteColor;
    k32u maxPaletteColor;
    kProjectorPatternMode patternModes;

    k32u defaultPatternCount;
    kProjectorPatternMode defaultPatternMode;
    k32u defaultPalette[kPROJECTOR_PALETTE_CAPACITY];
    k32u defaultIntensity;
    k64u defaultExposure;
    k64u defaultGap;
    kSize defaultBitDepth;

    k64u pilotRunExposure;
    k64u pilotRunPeriod;
    k32u pilotRunIntensity;

    kBool hasDynamicFrameRate;
    kBool isPilotRunNeeded;
    kBool isCalibrationNeeded;
    kBool hasTempProbe;
    kBool canAutoShutdown;

} kProjectorInfoClass; 

typedef struct kProjectorInfoVTable
{
    kObjectVTable base; 

    k64u(kCall* VImageTime)(kProjectorInfo info, kSize bitDepth, k64u exposure, kBool dynFrameRate);
    k64u(kCall* VFrameTime)(kProjectorInfo info, kSize bitDepth, k64u exposure, kBool dynFrameRate);
    kStatus(kCall* VCalculateExposure)(kProjectorInfo info, kSize bitDepth, k64u exposure, k64u cameraDuration, kBool dynFrameRate, kProjectorTiming* timing);
    k64u(kCall* VSequenceDuration)(kProjectorInfo info, kSize bitDepth, k64u exposure, k64u cameraDuration, kBool dynFrameRate, kSize patternCount, kBool sequenceEnabled);
    k64u(kCall* VMinimumGap)(kProjectorInfo info, kSize bitDepth, k64u exposure, k64u cameraDuration, kBool dynFrameRate, kSize patternCount, kBool sequenceEnabled, k64u cameraPlProcessingTime);
    k64u(kCall* VMinExposure)(kProjectorInfo info, k32u intensity, k32u minIntensity);
    k64u(kCall* VNominateCameraExposure)(kProjectorInfo info, kSize bitDepth, k64u stateExposure, k64u cameraDuration, kBool dynFrameRate, k64u desiredExposure);
    kProjectorExtension(kCall* VExtensionTypes)(kProjectorInfo info);
} kProjectorInfoVTable; 

kDeclareVirtualClassEx(kFs, kProjectorInfo, kObject)
        
kFsFx(kStatus) kProjectorInfo_Init(kProjectorInfo info, kType type, kProjectorModel model, k64f pixelClockFrequency, kAlloc alloc);
kFsFx(kStatus) kProjectorInfo_VRelease(kProjectorInfo info);

kFsFx(k64u) kProjectorInfo_VImageTime(kProjectorInfo info, kSize bitDepth, k64u exposure, kBool dynFrameRate);
kFsFx(k64u) kProjectorInfo_VFrameTime(kProjectorInfo info, kSize bitDepth, k64u exposure, kBool dynFrameRate);
kFsFx(kStatus) kProjectorInfo_VCalculateExposure(kProjectorInfo info, kSize bitDepth, k64u exposure, k64u cameraDuration, kBool dynFrameRate, kProjectorTiming* timing);
kFsFx(k64u) kProjectorInfo_VSequenceDuration(kProjectorInfo info, kSize bitDepth, k64u exposure, k64u cameraDuration, kBool dynFrameRate, kSize patternCount, kBool sequenceEnabled);
kFsFx(k64u) kProjectorInfo_VMinimumGap(kProjectorInfo info, kSize bitDepth, k64u exposure, k64u cameraDuration, kBool dynFrameRate, kSize patternCount, kBool sequenceEnabled, k64u cameraPlProcessingTime);
kFsFx(k64u) kProjectorInfo_VMinExposure(kProjectorInfo info, k32u intensity, k32u minIntensity);
kFsFx(k64u) kProjectorInfo_VNominateCameraExposure(kProjectorInfo info, kSize bitDepth, k64u stateExposure, k64u cameraDuration, kBool dynFrameRate, k64u desiredExposure);
kFsFx(kProjectorExtension) kProjectorInfo_VExtensionTypes(kProjectorInfo info);

#define kProjectorInfo_PatternModes_(C)         (xkProjectorInfo_CastRaw(C)->patternModes)

#endif
