/** 
 * @file    kDp01Info.x.h
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_DP01_INFO_X_H
#define K_FIRESYNC_DP01_INFO_X_H

#define kDP01_WIDTH                             (608)
#define kDP01_HEIGHT                            (684)

#define kDP01_MIN_PATTERN_COUNT                 (1)                 ///< Minimum pattern count.
#define kDP01_MAX_PATTERN_COUNT                 (96)                ///< Maximum pattern count.
#define kDP01_MAX_FRAME_REPEAT_COUNT            (255)               ///< Maximum frame repeat count.

#define kDP01_MIN_BIT_DEPTH                     (4)                 ///< Minimum pattern bit depth.
#define kDP01_MAX_BIT_DEPTH                     (8)                 ///< Maximum pattern bit depth.
#define kDP01_DEFAULT_BIT_DEPTH                 (8)                 ///< Default pattern bit depth.

#define kDP01_MIN_INTENSITY                     (0)                 ///< Minimum intensity.
#define kDP01_MAX_INTENSITY                     (255)               ///< Maximum intensity.
#define kDP01_DEFAULT_INTENSITY                 (90)                ///< Default intensity.

#define kDP01_MIN_PALETTE_COLOR                 (0)                 ///< Minimum palette color.
#define kDP01_MAX_PALETTE_COLOR                 (255)               ///< Maximum palette color.

#define kDLPC300_REG_VIDEO_FRAME_RATE_60HZ      (0x0859)
#define kDLPC300_REG_VIDEO_FRAME_RATE_45HZ      (0x0B21)
#define kDLPC300_REG_VIDEO_FRAME_RATE_40HZ      (0x0C85)

#define kDP01_HSYNC_WIDTH_60HZ                  (21)                ///< HSync width for 60 Hz.
#define kDP01_HSYNC_BACK_PORCH_60HZ             (20)                ///< HSync back porche for 60 Hz.
#define kDP01_HSYNC_FRONT_PORCH_60HZ            (20)                ///< HSync front porche for 60 Hz.
#define kDP01_VSYNC_WIDTH_60HZ                  (5)                 ///< VSync width for 60 Hz.
#define kDP01_VSYNC_BACK_PORCH_60HZ             (70)                ///< VSync back porche for 60 Hz.
#define kDP01_VSYNC_FRONT_PORCH_60HZ            (70)                ///< VSync front porche for 60 Hz.

#define kDP01_HSYNC_WIDTH_45HZ                  (19)                ///< HSync width for 45 Hz.
#define kDP01_HSYNC_BACK_PORCH_45HZ             (20)                ///< HSync back porche for 45 Hz.
#define kDP01_HSYNC_FRONT_PORCH_45HZ            (20)                ///< HSync front porche for 45 Hz.
#define kDP01_VSYNC_WIDTH_45HZ                  (5)                 ///< VSync width for 45 Hz.
#define kDP01_VSYNC_BACK_PORCH_45HZ             (210)               ///< VSync back porche for 45 Hz.
#define kDP01_VSYNC_FRONT_PORCH_45HZ            (210)               ///< VSync front porche for 45 Hz.

#define kDP01_HSYNC_WIDTH_40HZ                  (31)                ///< HSync width for 40 Hz.
#define kDP01_HSYNC_BACK_PORCH_40HZ             (31)                ///< HSync back porche for 40 Hz.
#define kDP01_HSYNC_FRONT_PORCH_40HZ            (30)                ///< HSync front porche for 40 Hz.
#define kDP01_VSYNC_WIDTH_40HZ                  (5)                 ///< VSync width for 40 Hz.
#define kDP01_VSYNC_BACK_PORCH_40HZ             (250)               ///< VSync back porche for 40 Hz.
#define kDP01_VSYNC_FRONT_PORCH_40HZ            (250)               ///< VSync front porche for 40 Hz.

#define kDP01_INFO_MIN_EXPOSURE                 (0)                 ///< DP01 minimum exposure. (real ns)
#define kDP01_INFO_DEFAULT_EXPOSURE             (2000000)           ///< DP01 default exposure. (real ns)

#define kDP01_INFO_PILOT_RUN_EXPOSURE           (16000000)          ///< DP01 pilot run exposure
#define kDP01_INFO_PILOT_RUN_PERIOD             (17030000)          ///< DP01 pilot run period
#define kDP01_INFO_PILOT_RUN_INTENSITY          (128)               ///< DP03 pilot run intensity.
#define kDP01_INFO_MIN_SEQUENCE_GAP             (12000000)          ///< DP01 minimum gap between sequences (ns); based on DP01 EoE ISR time; empirically, less than 9 ms (FSS-1362).

#define kDP01_ELIMINATE_FLICKER_FACTOR          (500000)             ///< Factor to eliminate flicker for one pattern projecting (real ns).

#define kDP01_STREAMING_PATTERN_MODE_THRESHOLD  (20000000)          ///< Exposure threshold to use streaming pattern mode (real ns).
#define kDP01_STREAMING_PATTERN_MODE_FRAME_GAP  (330000)            ///< Gap between frames in streaming pattern mode (real ns).
#define kDP01_STREAMING_PATTERN_MODE_IMAGE_GAP  (10000)             ///< Gap between images in streaming pattern mode (real ns).

typedef struct kDp01InfoClass
{
    kProjectorInfoClass base; 
    kMap frameRateControl;                  //Maps frame rate to frame rate control parameters -- kMap<kSize, kDp01FrameRateControl>
    kMap streamingPatternSequence;          //Maps bit-depth to streaming pattern mode exposure sequence lists -- kMap<kSize, kArrayList<kDlpc300VideoSequence>>
    kMap storedPatternSequence;             //Maps bit-depth to stored pattern mode exposure sequence lists -- kMap<kSize, kArrayList<kDlpc300VideoSequence>>
} kDp01InfoClass;

kDeclareClassEx(kFs, kDp01Info, kProjectorInfo)
        
kFsFx(kStatus) kDp01Info_Init(kDp01Info info, kType type, k64f pixelClockFrequency, kAlloc alloc);
kFsFx(kStatus) kDp01Info_VRelease(kDp01Info info);

kFsFx(kStatus) kDp01Info_ComposeFrameRateControl(kDp01Info info);
kFsFx(kStatus) kDp01Info_AddSequence(kDp01Info info, kMap map, kSize bitDepth, kSize itemSize, const void* sequence, kSize count);
kFsFx(kStatus) kDp01Info_ComposeStreamingPatternSequence(kDp01Info info);
kFsFx(kStatus) kDp01Info_ComposeStoredPatternSequence(kDp01Info info);

kFsFx(kStatus) kDp01Info_DetermineVideoSequence(kDp01Info info, kSize bitDepth, k64u exposure, kBool dynFrameRate, kProjectorTiming* timing);

kFsFx(k64u) kDp01Info_ImageLedTime(kDp01Info info, const kProjectorTiming* timing);
kFsFx(k64u) kDp01Info_ImageDuration(kDp01Info info, const kProjectorTiming* timing);
kFsFx(k64u) kDp01Info_StreamingFrameTime(kDp01Info info, const kDlpc300VideoSequence* sequence);

kFsFx(k64u) kDp01Info_VImageTime(kDp01Info info, kSize bitDepth, k64u exposure, kBool dynFrameRate);
kFsFx(k64u) kDp01Info_VFrameTime(kDp01Info info, kSize bitDepth, k64u exposure, kBool dynFrameRate);
kFsFx(kStatus) kDp01Info_VCalculateExposure(kDp01Info info, kSize bitDepth, k64u exposure, k64u cameraDuration, kBool dynFrameRate, kProjectorTiming* timing);
kFsFx(k64u) kDp01Info_VSequenceDuration(kDp01Info info, kSize bitDepth, k64u exposur, k64u cameraDuratione, kBool dynFrameRate, kSize patternCount, kBool sequenceEnabled);
kFsFx(k64u) kDp01Info_VMinimumGap(kDp01Info info, kSize bitDepth, k64u exposure, k64u cameraDuration, kBool dynFrameRate, kSize patternCount, kBool sequenceEnabled, k64u cameraPlProcessingTime);
kFsFx(k64u) kDp01Info_VNominateCameraExposure(kDp01Info info, kSize bitDepth, k64u stateExposure, k64u cameraDuration, kBool dynFrameRate, k64u desiredExposure);
kFsFx(kProjectorExtension) kDp01Info_VExtensionTypes(kDp01Info info);

#endif
