/** 
 * @file    kDiscoveryProvider.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_DISCOVERY_PROVIDER_X_H
#define K_FIRESYNC_DISCOVERY_PROVIDER_X_H

#define kDISCOVERY_PROVIDER_DEFAULT_RESET_HOLD_TIME        (7000000)

typedef struct kDiscoveryProviderVTable
{   
    kStatus (kCall* VConstruct)(kDiscoveryProvider* provider, kSystem system, kAlloc allocator); 

    k64u (kCall* VResetHoldTime)(kDiscoveryProvider provider, kVersion protocolVersion); 
    kBool (kCall* VCanSetAddress)(kDiscoveryProvider provider);
    kStatus (kCall* VSetAddress)(kDiscoveryProvider provider, k32u id, kSize localAdapterId, kSize nodeInterfaceIndex, const kIpConfig* ipConfig);
    kStatus (kCall* VSetEnumHandler)(kDiscoveryProvider provider, kDiscoveryEnumFx function, kPointer receiver); 
    kStatus (kCall* VSetAddressChangeHandler)(kDiscoveryProvider provider, kDiscoveryAddressChangeFx function, kPointer receiver); 
    kStatus (kCall* VStartEnum)(kDiscoveryProvider provider);
    kStatus (kCall* VWaitFirst)(kDiscoveryProvider provider);
    kStatus (kCall* VStopEnum)(kDiscoveryProvider provider);
    kStatus (kCall* VStartRescueRequests)(kDiscoveryProvider provider);
    kStatus (kCall* VStopRescueRequests)(kDiscoveryProvider provider);
    kStatus (kCall* VConstructNodeProvider)(kDiscoveryProvider provider, const kDiscoveryInfo* info, kNodeProvider* nodeProvider, kAlloc allocator);
    kStatus (kCall* VAddAdapter)(kDiscoveryProvider provider, const kChar* interfaceName);
} kDiscoveryProviderVTable;

kDeclareInterfaceEx(kFs, kDiscoveryProvider, kNull) 

kFsFx(kStatus) kDiscoveryProvider_VConstruct(kDiscoveryProvider* provider, kSystem system, kAlloc allocator); 

kFsFx(k64u) kDiscoveryProvider_VResetHoldTime(kDiscoveryProvider provider, kVersion protocolVersion); 

kFsFx(kBool) kDiscoveryProvider_VCanSetAddress(kDiscoveryProvider provider); 
kFsFx(kStatus) kDiscoveryProvider_VSetAddress(kDiscoveryProvider provider, k32u id, kSize localAdapterId, kSize nodeInterfaceIndex, const kIpConfig* ipConfig);

kFsFx(kStatus) kDiscoveryProvider_VSetEnumHandler(kDiscoveryProvider provider, kDiscoveryEnumFx function, kPointer receiver); 
kFsFx(kStatus) kDiscoveryProvider_VSetAddressChangeHandler(kDiscoveryProvider provider, kDiscoveryAddressChangeFx function, kPointer receiver); 

kFsFx(kStatus) kDiscoveryProvider_VStartEnum(kDiscoveryProvider provider); 
kFsFx(kStatus) kDiscoveryProvider_VWaitFirst(kDiscoveryProvider provider); 
kFsFx(kStatus) kDiscoveryProvider_VStopEnum(kDiscoveryProvider provider); 

kFsFx(kStatus) kDiscoveryProvider_VStartRescueRequests(kDiscoveryProvider provider); 
kFsFx(kStatus) kDiscoveryProvider_VStopRescueRequests(kDiscoveryProvider provider); 

kFsFx(kStatus) kDiscoveryProvider_VConstructNodeProvider(kDiscoveryProvider provider, const kDiscoveryInfo* info, kNodeProvider* nodeProvider, kAlloc allocator); 
        
kFsFx(kStatus) kDiscoveryProvider_VAddAdapter(kDiscoveryProvider provider, const kChar* interfaceName);

#endif
