/** 
 * @file    kData6Client.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_DATA_6_CLIENT_X_H
#define K_FIRESYNC_DATA_6_CLIENT_X_H

#include <kApi/Io/kTcpClient.h>

#define kDATA_6_CLIENT_CLIENT_READ_BUFFER                (1024*1024)             
#define kDATA_6_CLIENT_DEFAULT_SOCKET_READ_BUFFER        (kSYSTEM_DATA_NET_BUFFER_SIZE_DEFAULT)             
#define kDATA_6_CLIENT_SOCKET_WRITE_BUFFER               (-1) 

#define kDATA_6_CLIENT_CONNECT_TIMEOUT                   (1000000)

#define kDATA_6_CLIENT_CONFIGURATION_TIMEOUT             (100000)

typedef struct kData6ClientClass
{
    kObjectClass base; 

    kLock receiveLock;                      //Provides exlusive access to callback
    kCallback receiveFx;                    //Message callback. 
    kArrayList sourcePorts;                 //List of remote block ports -- kArrayList<k16u>.
    kAlloc messageAlloc;                    //Message allocator.
    kSize socketReadBufferSize;             //Socket read buffer size (bytes).

    kStatus beginOpenStatus;                //Used to communicate state between BeginOpen/EndOpen. 
    kTimer beginOpenTimer;                  //Timer used with BeginOpen operation. 

    kTcpClient client;                      //Connection socket. 
    kSerializer serializer;                 //Message deserializer.

    k64s endSessionCount;                   //Incremented when end-of-session message is expected.

    kThread thread;                         //Receive thread.

} kData6ClientClass; 

kDeclareClassEx(kFs, kData6Client, kObject)
        
kFsFx(kStatus) kData6Client_Init(kData6Client client, kType type, kAlloc alloc); 
kFsFx(kStatus) kData6Client_VRelease(kData6Client client); 

kFsFx(kStatus) kData6Client_ThreadEntry(kData6Client client); 

kFsFx(kStatus) kData6Client_SendConfiguration(kData6Client client); 
kFsFx(kStatus) kData6Client_ReceiveNextMessage(kData6Client client); 

kFsFx(kBool) kData6Client_IsConfigurationReply(kObject object); 
kFsFx(kBool) kData6Client_IsEndOfSession(kObject object); 

#endif
