/** 
 * @file    kControl5Client.h
 * @brief   Declares the kControl5Client class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CONTROL_5_CLIENT_H
#define K_FIRESYNC_CONTROL_5_CLIENT_H

#include <kFireSync/kNodeDef.h>

/**
 * @internal
 * @class   kControl5Client
 * @extends kObject
 * @ingroup kFireSync-Client-Network
 * @brief   Implements an FCP-5 client. 
 */
//typedef kObject kControl5Client;            --forward-declared in kFsDef.x.h

/** 
 * Constructs a kControl5Client object.
 *
 * @public              @memberof kControl5Client
 * @return              Operation status. 
 */
kFsFx(kStatus) kControl5Client_Construct(kControl5Client* client, kAlloc allocator); 

kFsFx(kStatus) kControl5Client_Open(kControl5Client client, k32u id, kIpAddress address); 

kFsFx(kStatus) kControl5Client_Close(kControl5Client client); 

kFsFx(kStatus) kControl5Client_WriteFirmware(kControl5Client client, kNodeFirmwareType type, kStream stream, kSize size, kCallbackFx progress, kPointer context); 
kFsFx(kStatus) kControl5Client_Reset(kControl5Client client); 
kFsFx(kStatus) kControl5Client_GetInfo(kControl5Client client, kNodeInfo* info); 

#include <kFireSync/Client/Network/kControl5Client.x.h>

#endif
