/** 
 * @file    kLightSteps.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LIGHT_STEPS_X_H
#define K_FIRESYNC_LIGHT_STEPS_X_H

typedef struct kLightStep
{
    kSize state;                //state index
    kSize count;                //repetition count
} kLightStep;

kDeclareValueEx(kFs, kLightStep, kValue)

typedef struct kLightStepsClass
{
    kLightExtClass base; 
    kArrayList steps;           //Step list -- kArrayList<kLightStep>
    kCameraStepsStyle style;    //Steps style
} kLightStepsClass;

kDeclareClassEx(kFs, kLightSteps, kLightExt)
        
kFsFx(kStatus) xkLightSteps_Construct(kLightSteps* extension, kAlloc allocator); 

kFsFx(kStatus) kLightSteps_Init(kLightSteps extension, kType type, kSize initialCount, kAlloc alloc); 
kFsFx(kStatus) kLightSteps_VRelease(kLightSteps extension); 

kFsFx(kStatus) kLightSteps_VClone(kLightSteps extension, kLightSteps other, kAlloc valueAlloc, kObject context); 

kFsFx(kStatus) kLightSteps_VRead(kLightSteps extension, kXml xml, kXmlItem item); 
kFsFx(kStatus) kLightSteps_VWrite(kLightSteps extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kLightSteps_VerificationLabel(kLightSteps extension, kChar* label, kSize capacity); 
kFsFx(kStatus) kLightSteps_VVerify(kLightSteps extension); 

kFsFx(kStatus) kLightSteps_VNextStates(kLightSteps extension, kSize stateIndex, kSize stateCount, kArrayList nextStates); 
kFsFx(k64u) kLightSteps_VMinimumPeriod(kLightSteps extension); 

kFsFx(kLightStep*) kLightSteps_StepAt(kLightSteps extension, kSize index); 

#define kLightSteps_Count_(S)                  kArrayList_Count(xkLightSteps_CastRaw(S)->steps)
#define kLightSteps_RepetitionCount_(S, I)     ((kArrayList_AtT(xkLightSteps_CastRaw(S)->steps, (I), kLightStep))->count)
#define kLightSteps_State_(S, I)               ((kArrayList_AtT(xkLightSteps_CastRaw(S)->steps, (I), kLightStep))->state)

#endif
